import infra.callisto.controllers.utils.sandbox_utils as sandbox_utils


def generate_rs_configs_task(location, db_timestamp, topology, tier, namespace_prefix, subresources,
                             rs_group, basesearch_groups=None, basesearch_hamsters_groups=None,
                             endpoint_set_template=None, endpoint_set_hamster_template=None,
                             readonly=True):
    task_type = 'GENERATE_CAJUPER_CHUNKS_CONFIGS'

    return sandbox_utils.run_only_task(
        task_type,
        {
            'location': location,
            'db_timestamp': db_timestamp,
            'topology': topology,
            'namespace_prefix': namespace_prefix,
            'chunk_namespace_prefix': 'images/prod/chunks',
            'subresources': subresources,
            'remote_storage_group': rs_group,
            'basesearch_groups': basesearch_groups or [],
            'basesearch_hamster_groups': basesearch_hamsters_groups or [],
            'tier_name': tier.name,
            'endpoint_set_template': endpoint_set_template or '',
            'endpoint_set_hamster_template': endpoint_set_hamster_template or '',
        },
        'Generate parts configs for {}, db timestamp {}'.format(location, db_timestamp),
        tags=['images', location, tier.name],
        hints=[db_timestamp],
        readonly=readonly,
    )


def switch_pip_configs_task(db_timestamp, readonly):
    task_type = 'SWITCH_IMAGES_PIP_CONFIGS'

    return sandbox_utils.run_only_task(
        task_type,
        {'db_timestamp': int(db_timestamp)},
        'Switch remote storage configs to {} at PIP'.format(db_timestamp),
        auto_release=True,
        tags=['IMAGES', 'pip'],
        hints=['newdb_{}'.format(db_timestamp)],
        readonly=readonly
    )
