import functools

import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

from infra.callisto.controllers.user.jupiter.chunks.external import Controller as ExternalChunksController
import deploy_params
import sandbox_tasks
import tier_chunks

default_topology = 'stable-158-r1812'
deployer_groups = [
    ('SAS_IMGS_DEPLOY', default_topology),
]

LOCATION = 'sas'
NAMESPACE_PREFIX = '/images/prod/'
NAMESPACE_PREFIX_YT = '/images/prod/yt'
SUBRESOURCES = ('',)

TIER0_BASESEARCH_GROUP = 'SAS_IMGS_BASE'
TIER0_REMOTE_STORAGE_GROUP = 'SAS_IMGS_REMOTE_STORAGE_BASE'
TIER0_ENDPOINT_SET_TEMPLATE = 'sas@sas-images-search.sas-images-tier0-base.{}'

TIER0_BASESEARCH_HAMSTER_GROUP = 'SAS_IMGS_BASE_HAMSTER'
TIER0_ENDPOINT_SET_HAMSTER_TEMPLATE = 'sas@sas-images-search.sas-images-tier0-base.{}.hamster'


def make_controller(readonly):
    callback = deploy_params.DownloadArgs(
        deployer_instances=gencfg_api.searcher_lookup_agents(*deployer_groups[0], mtn=True),
    )
    deploy_ctrl = deploy_controller.make_controller(deployer_groups, download_args_callback=callback, mtn=True)
    slot_ctrls = search_source.make_slot_controllers(
        slots_(),
        deploy_ctrl,
        deploy_only=True,
        namespace_prefix=NAMESPACE_PREFIX,
    )
    slot_ctrls['tier0_chunks_ext'] = ExternalChunksController(
        tier_chunks.location_status(LOCATION),
        tier_chunks.location_target(LOCATION),
        tier=tier.ImgTier0,
        optional=True,
        readonly=readonly
    )

    return search_source.YtDrivenSourceController(
        name='images_prod_sas',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly),
        status_table=get_yt_status_table(readonly),
    )


def slots_(topology=default_topology):
    return [
        slots.Slot('ImgTier0', tier.ImgTier0, TIER0_BASESEARCH_GROUP, topology),
        slots.Slot('ImgTier1', tier.ImgTier1, 'SAS_IMGS_T1_BASE', topology),
        slots.Slot('Embedding', tier.ImgEmbeddingTier0, 'SAS_IMGS_TIER0_EMBEDDING', topology),
        slots.Slot('InvIndex', tier.ImgInvIndexTier0, 'SAS_IMGS_INVERTED_INDEX', topology),
        slots.Slot('ImgMmeta', tier.ImgMmetaTier0, 'SAS_IMGS_MMETA', topology),
        slots.Slot('ImgMmetaHamster', tier.ImgMmetaTier0, 'SAS_IMGS_MMETA_HAMSTER', topology),
        slots.Slot('ImgMmetaHeater', tier.ImgMmetaTier0, 'SAS_IMAGES_HEATER_MMETA', topology),
        slots.Slot('ImgMmetaQuickTest', tier.ImgMmetaTier0, 'SAS_IMAGES_REFRESH_QUICK_MMETA_TEST', topology),
        slots.Slot('ImgMmetaCommercialPip', tier.ImgMmetaTier0, 'SAS_IMGS_MR_MMETA_TEST', topology),
    ]


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, 'images/prod/sas/target', readonly)


def get_yt_status_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_status_table(yt_client, 'images/prod/sas/status', readonly)


registry.register('images/prod/sas', make_controller, [registry.ReportsBackends.V2.sas])
