import datetime

import infra.callisto.controllers.search_source.controller as search_source

from notifications import PipNotReadyNotification


class SimplePipController(search_source.YtDrivenSourceController):
    def notifications(self):
        super_notifications = super(SimplePipController, self).notifications()
        since_target_modified = int((datetime.datetime.now() - self._target_modification_time).total_seconds())
        if (
            self._target_modification_time != datetime.datetime.min and
            self._searcher_target_state and
            len(self._searcher_target_state) > 1 and
            self._searcher_target_state != self.get_observed_state()[1]
        ):
            return super_notifications + [PipNotReadyNotification(since_target_modified)]
        return super_notifications + [PipNotReadyNotification(0)]
