import infra.callisto.controllers.build.innerbuilder as builder
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk as sdk
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import yt_observers


class Ctrl(sdk.Controller):
    path = 'ImgThumb'

    def __init__(self):
        super(Ctrl, self).__init__()
        topology = 'stable-143-r860'
        self._builder_wide = builder.make_controller(
            yt_observers.ImgThumbWide,
            instance_provider=gencfg_api.InstanceProvider(
                [gencfg_api.GencfgGroup('VLA_IMTUB_WIDE_BUILD', topology, mtn=False)],
                report_tags={'VLA_IMTUB_WIDE_BUILD'}
            ),
            space_needed_full_build_coeff=1.0,
            space_needed_inc_build_coeff=0.3,
            assist_last_n_on_finish=150,
        )
        self._builder_large = builder.make_controller(
            yt_observers.ImgThumbLarge,
            instance_provider=gencfg_api.InstanceProvider(
                [gencfg_api.GencfgGroup('VLA_IMTUB_LARGE_BUILD', topology, mtn=False)],
                report_tags={'VLA_IMTUB_LARGE_BUILD'}
            ),
            space_needed_full_build_coeff=1.0,
            space_needed_inc_build_coeff=0.3,
            assist_last_n_on_finish=150,
        )
        self.register(self._builder_wide, self._builder_large)


def make_img_thumb_controller(readonly):
    return Ctrl()


registry.register('images/prod/thumb/wide', make_img_thumb_controller, [registry.ReportsBackends.V2.vla])
