import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

from infra.callisto.controllers.user.jupiter.chunks.external import Controller as ExternalChunksController
import deploy_params
import tier_chunks

default_topology = 'stable-155-r474'
deployer_groups = [
    ('VLA_IMGS_DEPLOY', default_topology),
]

LOCATION = 'vla'


def make_controller(readonly):
    callback = deploy_params.DownloadArgsOld(
        deployer_instances=gencfg_api.searcher_lookup_agents(*deployer_groups[0], mtn=True),
    )
    deploy_ctrl = deploy_controller.make_controller(deployer_groups, download_args_callback=callback, mtn=True)
    slot_ctrls = search_source.make_slot_controllers(
        slots_(default_topology),
        deploy_ctrl,
        deploy_only=True,
        namespace_prefix='/images/prod/',
    )
    slot_ctrls['tier0_chunks_ext'] = ExternalChunksController(
        tier_chunks.location_status(LOCATION),
        tier_chunks.location_target(LOCATION),
        tier=tier.ImgTier0,
        optional=True,
        readonly=readonly
    )

    return search_source.YtDrivenSourceController(
        name='images_prod_vla',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly),
        status_table=get_yt_status_table(readonly),
    )


def slots_(topology, suffix=''):
    return [
        slots.Slot('ImgTier0' + suffix, tier.ImgTier0, 'VLA_IMGS_BASE', topology),
        slots.Slot('ImgTier1' + suffix, tier.ImgTier1, 'VLA_IMGS_T1_BASE', topology),
        slots.Slot('Embedding' + suffix, tier.ImgEmbeddingTier0, 'VLA_IMGS_TIER0_EMBEDDING', topology),
        slots.Slot('InvIndex' + suffix, tier.ImgInvIndexTier0, 'VLA_IMGS_INVERTED_INDEX', topology),
        slots.Slot('ImgMmeta' + suffix, tier.ImgMmetaTier0, 'VLA_IMGS_MMETA', topology),
        slots.Slot('ImgMmetaHamster' + suffix, tier.ImgMmetaTier0, 'VLA_IMGS_MMETA_HAMSTER', topology),
        slots.Slot('ImgMmetaHeater' + suffix, tier.ImgMmetaTier0, 'VLA_IMAGES_HEATER_MMETA', topology),
    ] + [
        slots.Slot('ImgMultiBeta{}Mmeta'.format(num) + suffix, tier.ImgMmetaTier0, 'VLA_IMGS_MULTIBETA{}_MMETA'.format(num), topology)
        for num in range(1, 10)
    ] + [
        slots.Slot('ImgMultiMeta{}Mmeta'.format(num) + suffix, tier.ImgMmetaTier0, 'VLA_IMGS_MULTIMETA{}_MMETA'.format(num), topology)
        for num in range(1, 11)
    ]


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, 'images/prod/vla/target', readonly)


def get_yt_status_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_status_table(yt_client, 'images/prod/vla/status', readonly)


registry.register('images/prod/vla', make_controller, [registry.ReportsBackends.V2.vla])
