import infra.callisto.controllers.build.yt_observer as yt_observer
import infra.callisto.controllers.build.source as sources
import infra.callisto.controllers.build.task as tasks
import infra.callisto.controllers.sdk.tier as tiers

import commercial_consts


class _Tasks(object):
    class _BuildImgThumbShard(tasks.BuildJupiterShard):
        bundle_type = 'img_thumb'
        entry_point = 'imgsth/shard_download'

        def produce_config(self):
            config = super(_Tasks._BuildImgThumbShard, self).produce_config()
            config['args']['configure'] = False
            config['args']['configure_inc'] = True
            config['args']['required_shard_id'] = self._prev_shard_name
            config.pop('prev_shard_name', None)
            return config

    class BuildImgThumbWideShard(_BuildImgThumbShard):
        gencfg_tier = tiers.ImtubWideTier0

        def produce_config(self):
            config = super(_Tasks.BuildImgThumbWideShard, self).produce_config()
            config['args']['env']['BASE_PREFIX'] = 'images/taas'
            return config

    class BuildImgThumbLargeShard(_BuildImgThumbShard):
        gencfg_tier = tiers.ImtubLargeTier0

        def produce_config(self):
            config = super(_Tasks.BuildImgThumbLargeShard, self).produce_config()
            config['args']['env']['BASE_PREFIX'] = 'images/taas_big'
            return config

    class BuildImgMmetaTier0ProdShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.ImgMmetaTier0
        bundle_type = 'img'
        entry_point = 'imgmmeta/shard_download'

        def produce_config(self):
            config = super(_Tasks.BuildImgMmetaTier0ProdShard, self).produce_config()
            config['args']['env']['TIER_NAME'] = self.gencfg_tier.name
            config['args']['env']['BASE_PREFIX'] = 'images/images_fast'
            return config

    class BuildImgTier0ProdShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.ImgTier0
        bundle_type = 'img'
        entry_point = 'imgsbase/shard_download'

        def produce_config(self):
            config = super(_Tasks.BuildImgTier0ProdShard, self).produce_config()
            config['args']['env']['TIER_NAME'] = 'primary'
            config['args']['env']['ENABLE_DOUBLE_PANTHER'] = True
            config['args']['env']['BASE_PREFIX'] = 'images/images_fast'
            return config

    class BuildImgEmbeddingTier0ProdShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.ImgEmbeddingTier0
        bundle_type = 'img'
        entry_point = 'imgsbase/search_embedding_download'

        def produce_config(self):
            config = super(_Tasks.BuildImgEmbeddingTier0ProdShard, self).produce_config()
            config['args']['env']['TIER_NAME'] = self.gencfg_tier.name
            config['args']['env']['BASE_PREFIX'] = 'images'
            return config

    class BuildImgInvIndexTier0ProdShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.ImgInvIndexTier0
        bundle_type = 'img'
        entry_point = 'imgsbase/inverted_index_download'

        def produce_config(self):
            config = super(_Tasks.BuildImgInvIndexTier0ProdShard, self).produce_config()
            config['args']['env']['TIER_NAME'] = self.gencfg_tier.name
            config['args']['env']['BASE_PREFIX'] = 'images'
            return config

    class BuildImgTier1Shard(BuildImgTier0ProdShard):
        gencfg_tier = tiers.ImgTier1

        def produce_config(self):
            config = super(_Tasks.BuildImgTier1Shard, self).produce_config()
            config['args']['env']['TIER_NAME'] = 'garbage'
            return config

    class BuildImgTier0Shard(BuildImgTier0ProdShard):
        def produce_config(self):
            config = super(_Tasks.BuildImgTier0Shard, self).produce_config()
            config['args']['env']['BASE_PREFIX'] = 'images/main_acceptance'
            return config

    class BuildImgMmetaTier0Shard(BuildImgMmetaTier0ProdShard):
        def produce_config(self):
            config = super(_Tasks.BuildImgMmetaTier0Shard, self).produce_config()
            config['args']['env']['BASE_PREFIX'] = 'images/main_acceptance'
            return config

    class BuildImgTier0Beta2Shard(BuildImgTier0ProdShard):
        def produce_config(self):
            config = super(_Tasks.BuildImgTier0Beta2Shard, self).produce_config()
            config['args']['env']['BASE_PREFIX'] = 'images'
            return config

    class BuildImgMmetaTier0Beta2Shard(BuildImgMmetaTier0ProdShard):
        def produce_config(self):
            config = super(_Tasks.BuildImgMmetaTier0Beta2Shard, self).produce_config()
            config['args']['env']['BASE_PREFIX'] = 'images'
            return config

    class BuildImgRIMTierShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.ImgRIMTier
        bundle_type = 'img_rim'
        entry_point = 'imgsrim/shard_download'

        def produce_config(self):
            config = super(_Tasks.BuildImgRIMTierShard, self).produce_config()
            config['args']['env']['MR_RUNTIME'] = 'YT'
            config['args']['env']['YT_PREFIX'] = '//'
            config['args']['env']['BASE_PREFIX'] = self.yt_root
            return config

    class BuildImgCommercialTier0Shard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.ImgCommercialTier0
        bundle_type = 'img_commercial'
        entry_point = 'imgs_commercial_data/shard_download'

        def produce_config(self):
            config = super(_Tasks.BuildImgCommercialTier0Shard, self).produce_config()
            config['args']['env']['MR_RUNTIME'] = 'YT'
            config['args']['env']['YT_PREFIX'] = '//'
            config['args']['env']['BASE_PREFIX'] = self.yt_root
            return config


class Sources(object):
    ImagesMmetaBetaSource = sources.YtTableSource(
        root='//home/images/main_acceptance/shard_deploy/mmeta',
        proxy='arnold'
    )

    ImagesBetaSource = sources.YtTableSource(
        root='//home/images/main_acceptance/shard_deploy/main',
        proxy='arnold'
    )

    ImagesMmetaBeta2Source = sources.YtTableSource(
        root='//home/images/shard_deploy/mmeta',
        proxy='arnold'
    )

    ImagesBeta2Source = sources.YtTableSource(
        root='//home/images/shard_deploy/main',
        proxy='arnold'
    )

    ImagesEmbeddingTier0Beta2Source = sources.YtTableSource(
        root='//home/images/shard_deploy/new_runtime_beta',
        proxy='arnold'
    )

    ImagesInvIndexTier0Beta2Source = sources.YtTableSource(
        root='//home/images/shard_deploy/new_runtime_beta',
        proxy='arnold'
    )

    ImagesMmetaSource = sources.YtTableSource(
        root='//home/images/images_fast/shard_deploy/mmeta',
        proxy='arnold'
    )

    ImagesTier0Source = sources.YtTableSource(
        root='//home/images/images_fast/shard_deploy/main',
        proxy='arnold'
    )

    ImagesTier1Source = sources.YtTableSource(
        root='//home/images/images_fast/shard_deploy/garbage',
        proxy='arnold',
    )

    ImagesEmbeddingTier0Source = sources.YtTableSource(
        root='//home/images/images_fast/shard_deploy/new_runtime',
        proxy='arnold'
    )

    ImagesInvIndexTier0Source = sources.YtTableSource(
        root='//home/images/images_fast/shard_deploy/new_runtime',
        proxy='arnold'
    )

    ImgRIMTierSource = sources.YtTableSource(
        root='//home/images/relatedimages/shard_deploy/build_states',
        proxy='arnold',
    )

    ImgCommercialTier0Source = sources.YtTableSource(
        root=commercial_consts.YT_BUILD_STATES_TABLE,
        proxy='arnold',
    )

    ImgThumbWideSource = sources.YtTableSource(
        root='//home/images/taas/shard_deploy/taas',
        proxy='arnold',
        is_table_dynamic=True,
    )

    ImgThumbLargeSource = sources.YtTableSource(
        root='//home/images/taas_big/shard_deploy/taas',
        proxy='arnold',
        is_table_dynamic=True,
    )

VLA_TRACKER = 'http://vla-tracker-cajuper.n.yandex-team.ru'

ImgMmetaTier0Beta = yt_observer.Observer(
    tier=tiers.ImgMmetaTier0,
    name='ImgMmetaTier0',
    source=Sources.ImagesMmetaBetaSource,
    build_task_type=_Tasks.BuildImgMmetaTier0Shard,
    tracker_url=VLA_TRACKER,
    namespace='/images/betas/beta1',
)

ImgTier0Beta = yt_observer.Observer(
    tier=tiers.ImgTier0,
    name='ImgTier0',
    source=Sources.ImagesBetaSource,
    build_task_type=_Tasks.BuildImgTier0Shard,
    tracker_url=VLA_TRACKER,
    namespace='/images/betas/beta1',
)

ImgCbrTier0Beta = yt_observer.Observer(
    tier=tiers.ImgTier0,
    name='ImgCbrTier0',
    source=Sources.ImagesBetaSource,
    build_task_type=_Tasks.BuildImgTier0Shard,
    tracker_url=VLA_TRACKER,
    namespace='/images/betas/beta1',
)

ImgTier0Beta2 = yt_observer.Observer(
    tier=tiers.ImgTier0,
    name='ImgTier0',
    source=Sources.ImagesBeta2Source,
    build_task_type=_Tasks.BuildImgTier0Beta2Shard,
    tracker_url=VLA_TRACKER,
    namespace='/images/betas/beta2',
)

ImgCbrTier0Beta2 = yt_observer.Observer(
    tier=tiers.ImgTier0,
    name='ImgCbrTier0',
    source=Sources.ImagesBeta2Source,
    build_task_type=_Tasks.BuildImgTier0Beta2Shard,
    namespace='/images/betas/beta2',
)

ImgMmetaTier0Beta2 = yt_observer.Observer(
    tier=tiers.ImgMmetaTier0,
    name='ImgMmetaTier0',
    source=Sources.ImagesMmetaBeta2Source,
    build_task_type=_Tasks.BuildImgMmetaTier0Beta2Shard,
    tracker_url=VLA_TRACKER,
    namespace='/images/betas/beta2',
)

ImgEmbeddingTier0Beta2 = yt_observer.Observer(
    tier=tiers.ImgEmbeddingTier0,
    name='ImgEmbeddingTier0',
    source=Sources.ImagesEmbeddingTier0Beta2Source,
    build_task_type=_Tasks.BuildImgEmbeddingTier0ProdShard,
    tracker_url=VLA_TRACKER,
    namespace='/images/betas/beta2',
)

ImgInvIndexTier0Beta2 = yt_observer.Observer(
    tier=tiers.ImgInvIndexTier0,
    name='ImgInvIndexTier0',
    source=Sources.ImagesInvIndexTier0Beta2Source,
    build_task_type=_Tasks.BuildImgInvIndexTier0ProdShard,
    tracker_url=VLA_TRACKER,
    namespace='/images/betas/beta2',
)


# imgs prod

ImgMmetaTier0 = yt_observer.Observer(
    tier=tiers.ImgMmetaTier0,
    name='ImgMmetaTier0',
    source=Sources.ImagesMmetaSource,
    build_task_type=_Tasks.BuildImgMmetaTier0ProdShard,
    namespace='/images/prod/',
    tracker_url=VLA_TRACKER,
)

ImgTier0 = yt_observer.Observer(
    tier=tiers.ImgTier0,
    name='ImgTier0',
    source=Sources.ImagesTier0Source,
    build_task_type=_Tasks.BuildImgTier0ProdShard,
    namespace='/images/prod/',
    tracker_url=VLA_TRACKER,
)

ImgTier1 = yt_observer.Observer(
    tier=tiers.ImgTier1,
    name='ImgTier1',
    source=Sources.ImagesTier1Source,
    build_task_type=_Tasks.BuildImgTier1Shard,
    namespace='/images/prod/',
    tracker_url=VLA_TRACKER,
)

ImgEmbeddingTier0 = yt_observer.Observer(
    tier=tiers.ImgEmbeddingTier0,
    name='ImgEmbeddingTier0',
    source=Sources.ImagesEmbeddingTier0Source,
    build_task_type=_Tasks.BuildImgEmbeddingTier0ProdShard,
    tracker_url=VLA_TRACKER,
    namespace='/images/prod/',
)

ImgInvIndexTier0 = yt_observer.Observer(
    tier=tiers.ImgInvIndexTier0,
    name='ImgInvIndexTier0',
    source=Sources.ImagesInvIndexTier0Source,
    build_task_type=_Tasks.BuildImgInvIndexTier0ProdShard,
    tracker_url=VLA_TRACKER,
    namespace='/images/prod/',
)

# rim prod

ImgRIMTier = yt_observer.Observer(
    tier=tiers.ImgRIMTier,
    name='ImgRIMTier',
    source=Sources.ImgRIMTierSource,
    build_task_type=_Tasks.BuildImgRIMTierShard,
    namespace='/images/prod/rim/',
    tracker_url=VLA_TRACKER,
)

# commercial

ImgCommercialTier0 = yt_observer.Observer(
    tier=commercial_consts.TIER,
    name=commercial_consts.TIER.name,
    source=Sources.ImgCommercialTier0Source,
    build_task_type=_Tasks.BuildImgCommercialTier0Shard,
    namespace=commercial_consts.NAMESPACE,
    tracker_url=VLA_TRACKER,
)

# thumbs

ImgThumbWide = yt_observer.Observer(
    tier=tiers.ImtubWideTier0,
    name='ImgThumbWide',
    source=Sources.ImgThumbWideSource,
    build_task_type=_Tasks.BuildImgThumbWideShard,
    # namespace='/img/prod/thumb/',
    # tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
)

ImgThumbLarge = yt_observer.Observer(
    tier=tiers.ImtubLargeTier0,
    name='ImgThumbLarge',
    source=Sources.ImgThumbLargeSource,
    build_task_type=_Tasks.BuildImgThumbLargeShard,
    # namespace='/img/prod/thumb/',
    # tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
)
