import infra.callisto.controllers.slots as slots_module
import infra.callisto.controllers.multi_contour2 as multi_contour2
import infra.callisto.controllers.build.yt_observer as yt_observer
import infra.callisto.controllers.build.source as source
import infra.callisto.controllers.build.task as tasks
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.utils.gencfg_api as gencfg_api


class _Tasks(object):
    class BuildNightlyTestShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.PlatinumTier0
        disable_iss_shards = True

    class BuildNightlyMmetaTestShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.MsUserData
        disable_iss_shards = True
        entry_point = 'JUPITER_BUNDLE/msrun.sh'

    class BuildNightlyBaselineShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.PlatinumTier0
        disable_iss_shards = True

    class BuildNightlyMmetaBaselineShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.MsUserData
        disable_iss_shards = True
        entry_point = 'JUPITER_BUNDLE/msrun.sh'


class _YtObservers(object):
    NightlyTest = yt_observer.Observer(
        tier=tiers.PlatinumTier0,
        name='NightlyTest',
        source=source.YtTableSource(
            proxy='arnold',
            root='//home/jupiter-test/shard_deploy/nightly_test',
            use_time_as_generation=True,
        ),
        build_task_type=_Tasks.BuildNightlyTestShard,
        namespace='/web/betas/nightly/test/',
        tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
    )

    NightlyMmetaTest = yt_observer.Observer(
        tier=tiers.MsUserData,
        name='NightlyMmetaTest',
        source=source.YtTableSource(
            proxy='arnold',
            root='//home/jupiter-test/shard_deploy/nightly_test_middlesearch_shard',
            use_time_as_generation=True,
        ),
        build_task_type=_Tasks.BuildNightlyMmetaTestShard,
        namespace='/web/betas/nightly/test/',
        tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
    )

    NightlyBaseline = yt_observer.Observer(
        tier=tiers.PlatinumTier0,
        name='NightlyBaseline',
        source=source.YtTableSource(
            proxy='arnold',
            root='//home/jupiter-test/shard_deploy/nightly_baseline',
            use_time_as_generation=True,
        ),
        build_task_type=_Tasks.BuildNightlyBaselineShard,
        namespace='/web/betas/nightly/baseline/',
        tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
    )

    NightlyMmetaBaseline = yt_observer.Observer(
        tier=tiers.MsUserData,
        name='NightlyMmetaBaseline',
        source=source.YtTableSource(
            proxy='arnold',
            root='//home/jupiter-test/shard_deploy/nightly_baseline_middlesearch_shard',
            use_time_as_generation=True,
        ),
        build_task_type=_Tasks.BuildNightlyMmetaBaselineShard,
        namespace='/web/betas/nightly/baseline/',
        tracker_url='http://vla-tracker-cajuper.n.yandex-team.ru',
    )


def make_nightly_test_controller(readonly):
    tag = 'stable-158-r223'
    contour = multi_contour2.Contour(
        deployer_spec=multi_contour2.DeployerSpec(
            [('VLA_WEB_PLATINUM_JUPITER_BASE_TEST1_DEPLOY', tag)],
            use_mtn=True
        ),
        builders_specs=[
            multi_contour2.BuildCtrlSpec(
                yt_observer=_YtObservers.NightlyTest,
                instance_provider=gencfg_api.InstanceProvider(
                    [gencfg_api.GencfgGroup('VLA_WEB_PLATINUM_JUPITER_BASE_TEST1_BUILD', tag, mtn=True)],
                    report_tags={'VLA_WEB_PLATINUM_JUPITER_BASE_TEST1_BUILD'}
                ),
                assist_last_n_on_finish=5,
            ),
            multi_contour2.BuildCtrlSpec(
                yt_observer=_YtObservers.NightlyMmetaTest,
                instance_provider=gencfg_api.InstanceProvider(
                    [gencfg_api.GencfgGroup('VLA_WEB_PLATINUM_JUPITER_TEST1_MMETA_BUILD', tag, mtn=True)],
                    report_tags={'VLA_WEB_PLATINUM_JUPITER_TEST1_MMETA_BUILD'}
                ),
                assist_last_n_on_finish=1,
            ),
        ],
        sources_specs=[
            multi_contour2.SourceSpec(
                name='Base',
                source=_YtObservers.NightlyTest.source,
                slots=[
                    slots_module.Slot(
                        'Platinum',
                        tiers.PlatinumTier0,
                        'VLA_WEB_PLATINUM_JUPITER_BASE_TEST1',
                        tag,
                        use_mtn=True
                    )
                ],
            ),
            multi_contour2.SourceSpec(
                name='Mmeta',
                source=_YtObservers.NightlyMmetaTest.source,
                slots=[
                    slots_module.Slot(
                        'MsUser',
                        tiers.MsUserData,
                        'VLA_WEB_PLATINUM_JUPITER_TEST1_MMETA',
                        tag,
                        use_mtn=True
                    )
                ],
            )
        ],
        namespace_prefix='/web/betas/nightly/test/',
    )
    return multi_contour2.make_controller(contour, 'web/betas/nightly/test/status', readonly)


def make_nightly_baseline_controller(readonly):
    tag = 'stable-158-r1340'
    contour = multi_contour2.Contour(
        deployer_spec=multi_contour2.DeployerSpec(
            [('VLA_WEB_PLATINUM_JUPITER_BASE_TEST2_DEPLOY', tag)],
            use_mtn=True
        ),
        builders_specs=[
            multi_contour2.BuildCtrlSpec(
                yt_observer=_YtObservers.NightlyBaseline,
                instance_provider=gencfg_api.InstanceProvider(
                    [gencfg_api.GencfgGroup('VLA_WEB_PLATINUM_JUPITER_BASE_TEST2_BUILD', tag, mtn=True)],
                    report_tags={'VLA_WEB_PLATINUM_JUPITER_BASE_TEST2_BUILD'}
                ),
                assist_last_n_on_finish=5,
            ),
            multi_contour2.BuildCtrlSpec(
                yt_observer=_YtObservers.NightlyMmetaBaseline,
                instance_provider=gencfg_api.InstanceProvider(
                    [gencfg_api.GencfgGroup('VLA_WEB_PLATINUM_JUPITER_TEST2_MMETA_BUILD', tag, mtn=True)],
                    report_tags={'VLA_WEB_PLATINUM_JUPITER_TEST2_MMETA_BUILD'}
                ),
                assist_last_n_on_finish=1,
            ),
        ],
        sources_specs=[
            multi_contour2.SourceSpec(
                name='Base',
                source=_YtObservers.NightlyBaseline.source,
                slots=[
                    slots_module.Slot(
                        'Platinum',
                        tiers.PlatinumTier0,
                        'VLA_WEB_PLATINUM_JUPITER_BASE_TEST2',
                        tag,
                        use_mtn=True
                    )
                ],
            ),
            multi_contour2.SourceSpec(
                name='Mmeta',
                source=_YtObservers.NightlyMmetaBaseline.source,
                slots=[
                    slots_module.Slot(
                        'MsUser',
                        tiers.MsUserData,
                        'VLA_WEB_PLATINUM_JUPITER_TEST2_MMETA',
                        tag,
                        use_mtn=True
                    )
                ],
            )
        ],
        namespace_prefix='/web/betas/nightly/baseline/',
    )
    return multi_contour2.make_controller(contour, 'web/betas/nightly/baseline/status', readonly)


beta_reports = [registry.ReportsBackends.V2.vla]
registry.register('web/betas/nightly/test', make_nightly_test_controller, beta_reports)
registry.register('web/betas/nightly/baseline', make_nightly_baseline_controller, beta_reports)
