class DownloadArgs(object):
    def __init__(self, deployer_instances, enable_local_prob=False):
        self.enable_local_prob = enable_local_prob
        self._hdd_only_hosts = {
            agent.host for agent, spec in deployer_instances.items()
            if 'itag_copy_on_ssd' not in spec['tags']
        }
        self._slow_network_hosts = {
            agent.host for agent, spec in deployer_instances.items()
            if spec['host_resources'].get('net', 0) < 1100  # less then 1Gbit
        }

    def __call__(self, resource, host):
        check_policy = {'repeat_sky_get': bool('msuserdata' in resource.name)}

        if host in self._hdd_only_hosts or 'msuserdata' in resource.name:
            max_dl_speed, io_limit = '16M', '15M'
        elif host in self._slow_network_hosts:
            max_dl_speed, io_limit = '30M', '25M'
        else:
            max_dl_speed, io_limit = '75M', '70M'

        skybone_params = {
            'max_dl_speed': max_dl_speed,
            'hardlink': True,
            'copier_opts': '{direct_write: 1, subproc: 1, max_write_chunk: 131072}' if not self.enable_local_prob else
                           '{direct_write: 1, subproc: 1, max_write_chunk: 131072, local_prob: 0.8}',
            'check_policy': check_policy,
            'container_params': {
                'io_limit': '/ssd: {}'.format(io_limit),
                'io_policy': 'idle',
                'io_weight': 0.01
            }
        }

        return skybone_params


class DownloadArgsYp(DownloadArgs):
    def __call__(self, resource, host):
        max_dl_speed, io_limit = '64M', '15M'

        skybone_params = super(DownloadArgsYp, self).__call__(resource, host)
        skybone_params['max_dl_speed'] = max_dl_speed
        skybone_params['container_params']['io_limit'] = '/: {}'.format(io_limit)

        return skybone_params
