import cityhash
import datetime
import functools

import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

import deploy_params
import sandbox_tasks
import tier1


LOCATION='man'
default_topology = 'stable-155-r25'
deployer_groups = (
    ('MAN_WEB_DEPLOY', default_topology),
)

TIER0_BASESEARCH_GROUP = 'MAN_WEB_TIER0_BASE'
TIER0_ATTR_BASESEARCH_GROUP = 'MAN_WEB_TIER0_ATTRIBUTE_BASE'
TIER0_REMOTE_STORAGE_GROUP = 'MAN_WEB_TIER0_REMOTE_STORAGE_BASE'
TIER0_ENDPOINT_SET_TEMPLATE = 'man@man-web-search.tier0-base.{}'

TIER0_BASESEARCH_HAMSTER_GROUPS = [
    'MAN_WEB_TIER0_ATTRIBUTE_BASE_HAMSTER',
    'MAN_WEB_TIER0_BASE_HAMSTER',
    'MAN_WEB_TIER0_ATTRIBUTE_BASE_MULTI',
    'MAN_WEB_TIER0_BASE_MULTI',
]
TIER0_ENDPOINT_SET_HAMSTER_TEMPLATE = 'man@man-web-search.tier0-base.{}.hamster'

NAMESPACE_PREFIX = '/web/prod/'
NAMESPACE_PREFIX_YT = '/web/prod/yt/'
SUBRESOURCES = ('pudge', 'dynamic')


def slots_(topology=default_topology, name_suffix=''):
    return (
        slots.Slot('Platinum' + name_suffix, tier.PlatinumTier0, 'MAN_WEB_PLATINUM_JUPITER_BASE', topology),
        slots.WebTier1Slot('WebTier0' + name_suffix, tier.WebTier0, TIER0_BASESEARCH_GROUP, topology),
        slots.WebTier1Slot('WebTier0Attr' + name_suffix, tier.AttributeWebTier0, TIER0_ATTR_BASESEARCH_GROUP, topology),
        slots.Slot('JudTier' + name_suffix, tier.JudTier, 'MAN_WEB_JUD_JUPITER_BASE_NIDX', topology),
        slots.GeminiSlot('Gemini' + name_suffix, tier.GeminiTier, 'MAN_WEB_GEMINI_BASE', topology),
        slots.Slot('CastorSearchProxy' + name_suffix, tier.CastorTier, 'MAN_WEB_GEMINI_SEARCHPROXY_DYN', topology),

        slots.Slot('Mmeta' + name_suffix, tier.MsUserData, 'MAN_WEB_MMETA', topology),
        slots.Slot('HamsterMmeta' + name_suffix, tier.MsUserData, 'MAN_WEB_MMETA_HAMSTER', topology),
        slots.Slot('HamsterPrsMmeta' + name_suffix, tier.MsUserData, 'MAN_WEB_MMETA_PRS_HAMSTER', topology),
        slots.Slot('MmetaHeater' + name_suffix, tier.MsUserData, 'MAN_WEB_HEATER_MMETA', topology),

        slots.Slot('Multibeta1Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIBETA1_MMETA', topology),
        slots.Slot('Multibeta2Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIBETA2_MMETA', topology),
        slots.Slot('Multibeta3Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIBETA3_MMETA', topology),
        slots.Slot('Multibeta8Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIBETA8_MMETA', topology),

        slots.Slot('Multimeta1Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA1_MMETA', topology),
        slots.Slot('Multimeta2Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA2_MMETA', topology),
        slots.Slot('Multimeta3Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA3_MMETA', topology),
        slots.Slot('Multimeta4Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA4_MMETA', topology),
        slots.Slot('Multimeta5Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA5_MMETA', topology),
        slots.Slot('Multimeta6Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA6_MMETA', topology),
        slots.Slot('Multimeta7Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA7_MMETA', topology),
        slots.Slot('Multimeta8Mmeta' + name_suffix, tier.MsUserData, 'MAN_MULTIMETA8_MMETA', topology),
    )


def yt_slots_(topology=default_topology):
    return [
        slots.WebTier1Slot(
            'KeyInvWebTier0', tier.KeyInvWebTier0,
            'MAN_WEB_TIER0_KEYINV', topology),
        slots.Slot('EmbeddingWebTier0', tier.EmbeddingWebTier0,
                   'MAN_WEB_TIER0_EMBEDDING', topology),
        slots.Slot('InvertedIndexWebTier0', tier.InvertedIndexWebTier0,
                   'MAN_WEB_TIER0_INVERTED_INDEX', topology),
    ]


def tier0_rs_slots(topology=default_topology):
    return (
        ('MAN_WEB_TIER0_REMOTE_STORAGE_SLOTS_1', topology),
    )


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, 'web/prod/man/target', readonly)


def get_yt_status_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_status_table(yt_client, 'web/prod/man/status', readonly)


def make_controller(readonly):
    callback = deploy_params.DownloadArgs(gencfg_api.searcher_lookup_agents(*deployer_groups[0]),
                                          enable_local_prob=True)
    deploy_ctrl = deploy_controller.make_controller(deployer_groups, download_args_callback=callback, mtn=True)
    deploy_ctrl.reports_alive_threshold = datetime.timedelta(hours=2)
    slot_ctrls = search_source.make_slot_controllers(
        slots_(),
        deploy_ctrl,
        deploy_only=True,  # to not intersect with multibeta
        namespace_prefix=NAMESPACE_PREFIX,
    )
    slot_ctrls.update(search_source.make_slot_controllers(
        yt_slots_(),
        deploy_ctrl,
        deploy_only=True,  # to not intersect with multibeta
        namespace_prefix=NAMESPACE_PREFIX_YT))
    slot_ctrls['tier0_chunks'] = tier1.make_chunks_ctrl(
        location=LOCATION,
        deploy_ctrl=deploy_ctrl,
        namespace_prefix=NAMESPACE_PREFIX_YT,
        remote_storage_group=(TIER0_REMOTE_STORAGE_GROUP, default_topology),
        readonly=readonly,
        remote_storage_slots=tier0_rs_slots(default_topology),
        generation_max_space_share=0.5,
        subresources=SUBRESOURCES,
        configs_generator=functools.partial(
            sandbox_tasks.generate_rs_configs_task,
            location=LOCATION,
            topology=default_topology,
            tier=tier.WebTier0,
            namespace_prefix=NAMESPACE_PREFIX_YT,
            subresources=SUBRESOURCES,
            rs_group=TIER0_REMOTE_STORAGE_GROUP,
            basesearch_groups=[TIER0_BASESEARCH_GROUP, TIER0_ATTR_BASESEARCH_GROUP],
            basesearch_hamsters_groups=TIER0_BASESEARCH_HAMSTER_GROUPS,
            endpoint_set_template=TIER0_ENDPOINT_SET_TEMPLATE,
            endpoint_set_hamster_template=TIER0_ENDPOINT_SET_HAMSTER_TEMPLATE,
            readonly=readonly
        ),
        tier=tier.WebTier0,
        max_shard_parts_on_host=600,
        hash_function=cityhash.hash64,
        planner_version=2,
        hard_limit_multiplier=2.875,
    )
    return search_source.YtDrivenSourceController(
        name='man_web',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly),
        status_table=get_yt_status_table(readonly),
    )


registry.register('web/prod/man', make_controller, [registry.ReportsBackends.V2.man])
