import infra.callisto.controllers.multibeta.controller as multibeta_controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.controllers.utils.yp_utils as yp_utils
import infra.callisto.libraries.yt as yt_utils

import conf_generator
import configuration
from .. import oldprod2
import slots
import tables


man_topology = 'stable-152-r50'
vla_topology = 'stable-153-r195'

MAN_BASE_SLOTS = ('multibeta1', 'multibeta2', 'multibeta3', 'multibeta8')
# VLA_BASE_SLOTS = ('multibeta4', 'multibeta5', 'multibeta6', 'multibeta7')
VLA_BASE_SLOTS = ('multibeta4',)

DEPLOY_SLOTS = [
    (MAN_BASE_SLOTS, tiers.PlatinumTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.man, 'man-web-search.man-web-platinum-base', 20000), 10),
    (MAN_BASE_SLOTS, tiers.WebTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.man, 'man-web-search.tier0-base', 22000), 40),
    (MAN_BASE_SLOTS, tiers.AttributeWebTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.man, 'man-web-search.tier0-attr-base', 22000), 5),
    (VLA_BASE_SLOTS, tiers.PlatinumTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.vla, 'vla-web-search.vla-web-platinum-base', 20000), 10),
    (VLA_BASE_SLOTS, tiers.WebTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.vla, 'vla-web-search.tier0-base', 22000), 30),
    (VLA_BASE_SLOTS, tiers.AttributeWebTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.vla, 'vla-web-search.tier0-attr-base', 22000), 5),
]

MMETA_SLOTS = {
    # MAN
    'multibeta1': gencfg_api.GencfgGroup('MAN_MULTIBETA1_MMETA', man_topology, mtn=True),
    'multibeta2': gencfg_api.GencfgGroup('MAN_MULTIBETA2_MMETA', man_topology, mtn=True),
    'multibeta3': gencfg_api.GencfgGroup('MAN_MULTIBETA3_MMETA', man_topology, mtn=True),
    'multibeta8': gencfg_api.GencfgGroup('MAN_MULTIBETA8_MMETA', man_topology, mtn=True),
    # VLA
    'multibeta4': gencfg_api.GencfgGroup('VLA_MULTIBETA4_MMETA', vla_topology, mtn=True),
    'multibeta5': gencfg_api.GencfgGroup('VLA_MULTIBETA5_MMETA', vla_topology, mtn=True),
    'multibeta6': gencfg_api.GencfgGroup('VLA_MULTIBETA6_MMETA', vla_topology, mtn=True),
    'multibeta7': gencfg_api.GencfgGroup('VLA_MULTIBETA7_MMETA', vla_topology, mtn=True),
}

SLOTS = MMETA_SLOTS.keys()


def make_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def make_ctrl(readonly):
    yt_client = make_yt_client()
    target_table = get_target_table(readonly, yt_client=yt_client)
    return multibeta_controller.Ctrl(
        'multi_beta',
        target_table,
        multibeta_slots.SlotsCtrl(
            slots.make_deploy_base_ctrls(DEPLOY_SLOTS) +
            slots.make_mmeta_ctrls(MMETA_SLOTS)
        ),
        conf_generator.BaseBetaGenerator(
            oldprod2.get_status_table(),
            tables.YappyTable(yt_client, '//home/yappy/base_controllers'),
            get_configs_table(yt_client=yt_client),
            target_table,
            SLOTS,
        ),
        hard_switch=True
    )


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/web/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/web/multibeta/base/target', configuration.BaseBetaConfiguration, readonly
    )


registry.register('web/betas/multi/base', make_ctrl, [registry.ReportsBackends.V2.vla])
