import infra.callisto.controllers.multibeta.generator as generator

import configuration


class BaseBetaGenerator(generator.GeneratorProdTable):
    def _eval_target(self, yappy_conf, prod_conf, configs):
        return configuration.BaseBetaConfiguration(
            yappy_conf['revision'],
            _eval_mmeta(yappy_conf, prod_conf, configs),
            _eval_base(yappy_conf, prod_conf, configs),
        )

    def _prod_common_config(self):
        cfg = self._prod_table.last_status()
        return _convert_prod_common_config_to_yappy(cfg.config) if cfg.config else {}


class IntBetaGenerator(generator.GeneratorProdTable):
    def _eval_target(self, yappy_conf, prod_conf, configs):
        return configuration.IntBetaConfiguration(
            yappy_conf['revision'],
            _eval_mmeta(yappy_conf, prod_conf, configs),
            _eval_int(yappy_conf, prod_conf, configs),
        )

    def _prod_common_config(self):
        cfg = self._prod_table.last_status()
        return _convert_prod_common_config_to_yappy(cfg.config) if cfg.config else {}


class MmetaBetaGenerator(generator.GeneratorProdTable):
    def _eval_target(self, yappy_conf, prod_conf, configs):
        return configuration.MmetaBetaConfiguration(
            yappy_conf['revision'],
            _eval_mmeta(yappy_conf, prod_conf, configs),
        )

    def _prod_common_config(self):
        cfg = self._prod_table.last_status()
        return _convert_prod_common_config_to_yappy(cfg.config) if cfg.config else {}


class FullBetaGenerator(generator.GeneratorProdTable):
    def _eval_target(self, yappy_conf, prod_conf, configs):
        return configuration.FullBetaConfiguration(
            yappy_conf['revision'],
            _eval_mmeta(yappy_conf, prod_conf, configs),
            _eval_ranging_int(yappy_conf, prod_conf, configs),
            _eval_embedding(yappy_conf, prod_conf, configs),
            _eval_invindex(yappy_conf, prod_conf, configs),
            _eval_base(yappy_conf, prod_conf, configs),
            _eval_keyinv(yappy_conf, prod_conf, configs),
        )

    def _prod_common_config(self):
        cfg = self._prod_table.last_status()
        return _convert_prod_common_config_to_yappy(cfg.config) if cfg.config else {}


def _eval_mmeta(yappy_conf, prod_conf, configs):
    return configuration.MmetaConfiguration(
        generator.get_resource('mmeta.executable', yappy_conf, prod_conf),
        generator.get_resource('mmeta.models', yappy_conf, prod_conf),
        configs['mmeta.config'],
        configs['mmeta.config_path'],
    )


def _eval_int(yappy_conf, prod_conf, configs):
    return configuration.IntConfiguration(
        generator.get_resource('intsearch.executable', yappy_conf, prod_conf),
        configs['int.config'],
        configs['int.config_path'],
    )


def _eval_ranging_int(yappy_conf, prod_conf, configs):
    return configuration.IntRankingConfiguration(
        generator.get_resource('intsearch.executable', yappy_conf, prod_conf),
        generator.get_resource('intsearch.models', yappy_conf, prod_conf),
        configs['int.config'],
        configs['int.config_path'],
    )


def _eval_base(yappy_conf, prod_conf, configs):
    return configuration.BasesearchConfiguration(
        generator.get_resource('basesearch.executable', yappy_conf, prod_conf),
        generator.get_resource('basesearch.models', yappy_conf, prod_conf),
        configs['basesearch.config'],
        configs['basesearch.config_path'],
    )


def _eval_embedding(yappy_conf, prod_conf, configs):
    return configuration.EmbeddingConfiguration(
        generator.get_resource('embedding.executable', yappy_conf, prod_conf),
        generator.get_resource('embedding.models', yappy_conf, prod_conf),
        configuration.EmbeddingConfigs(
            configuration.InstanceConfig(
                configs['embedding.configs.server.resource'],
                configs['embedding.configs.server.path'],
            ),
            configuration.InstanceConfig(
                configs['embedding.configs.storage.resource'],
                configs['embedding.configs.storage.path'],
            ),
            configuration.InstanceConfig(
                configs['embedding.configs.replicas.resource'],
                configs['embedding.configs.replicas.path'],
            )
        )
    )


def _eval_invindex(yappy_conf, prod_conf, configs):
    return configuration.InvIndexConfiguration(
        generator.get_resource('invindex.executable', yappy_conf, prod_conf),
        configuration.InvIndexConfigs(
            configuration.InstanceConfig(
                configs['invindex.configs.server.resource'],
                configs['invindex.configs.server.path'],
            ),
            configuration.InstanceConfig(
                configs['invindex.configs.invindex.resource'],
                configs['invindex.configs.invindex.path'],
            )
        )
    )


def _eval_keyinv(yappy_conf, prod_conf, configs):
    return configuration.KeyInvConfiguration(
        generator.get_resource('keyinv.executable', yappy_conf, prod_conf),
        configuration.KeyInvConfigs(
            configuration.InstanceConfig(
                configs['keyinv.configs.server.resource'],
                configs['keyinv.configs.server.path'],
            ),
            configuration.InstanceConfig(
                configs['keyinv.configs.keyinv.resource'],
                configs['keyinv.configs.keyinv.path'],
            )
        )
    )


def _convert_prod_common_config_to_yappy(cfg):
    (
        keyinv, base,
        invindex, embedding,
        int_, mmeta,
    ) = (
        cfg['keyinv'], cfg['base'],
        cfg['invindex'], cfg['embedding'],
        cfg['int'], cfg['mmeta'],
    )

    return {
        'keyinv.executable': keyinv['httpsearch'],

        'basesearch.executable': base['httpsearch'],
        'basesearch.models': base['models.archive'],

        'invindex.executable': invindex['httpsearch'],

        'embedding.executable': embedding['httpsearch'],
        'embedding.models': embedding['models.archive'],

        'intsearch.executable': int_['httpsearch'],
        'intsearch.models': int_['models.archive'],

        'mmeta.executable': mmeta['httpsearch'],
        'mmeta.models': mmeta['models.archive'],
    }
