import infra.callisto.controllers.utils.nested_obj as nested_obj


class InstanceConfig(nested_obj.NestedObject):
    fields = (
        ('resource', nested_obj.String),
        ('path', nested_obj.String),
    )


class MmetaConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('models', nested_obj.String),
        ('config', nested_obj.String),
        ('config_path', nested_obj.String),
    )


class IntConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('config', nested_obj.String),
        ('config_path', nested_obj.String),
    )


class IntRankingConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('models', nested_obj.String),
        ('config', nested_obj.String),
        ('config_path', nested_obj.String),
    )


class EmbeddingConfigs(nested_obj.NestedObject):
    fields = (
        ('server', InstanceConfig),
        ('storage', InstanceConfig),
        ('replicas', InstanceConfig),
    )


class EmbeddingConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('models', nested_obj.String),
        ('configs', EmbeddingConfigs),
    )


class InvIndexConfigs(nested_obj.NestedObject):
    fields = (
        ('server', InstanceConfig),
        ('invindex', InstanceConfig),
    )


class InvIndexConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('configs', InvIndexConfigs),
    )


class KeyInvConfigs(nested_obj.NestedObject):
    fields = (
        ('server', InstanceConfig),
        ('keyinv', InstanceConfig),
    )


class KeyInvConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('configs', KeyInvConfigs),
    )


class BasesearchConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('models', nested_obj.String),
        ('config', nested_obj.String),
        ('config_path', nested_obj.String),
    )


class _Configuration(nested_obj.NestedObject):
    def __str__(self):
        return '{}({})'.format(self.__class__.__name__, self.revision)


class BaseBetaConfiguration(_Configuration):
    fields = (
        ('revision', nested_obj.Integer),
        ('mmeta', MmetaConfiguration),
        ('base', BasesearchConfiguration),
    )


class MmetaBetaConfiguration(_Configuration):
    fields = (
        ('revision', nested_obj.Integer),
        ('mmeta', MmetaConfiguration),
    )


class IntBetaConfiguration(_Configuration):
    fields = (
        ('revision', nested_obj.Integer),
        ('mmeta', MmetaConfiguration),
        ('int', IntConfiguration),
    )


class FullBetaConfiguration(_Configuration):
    fields = (
        ('revision', nested_obj.Integer),
        ('mmeta', MmetaConfiguration),
        ('int', IntRankingConfiguration),
        ('embedding', EmbeddingConfiguration),
        ('invindex', InvIndexConfiguration),
        ('base', BasesearchConfiguration),
        ('keyinv', KeyInvConfiguration),
    )
