import infra.callisto.controllers.multibeta.controller as multibeta_controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.controllers.utils.yp_utils as yp_utils
import infra.callisto.libraries.yt as yt_utils

import conf_generator
import configuration
from .. import oldprod2
import slots
import tables


sas_topology = 'stable-156-r55'

BASE_SLOTS = [
    (
        ('multifullbeta1', 'multifullbeta2'),
        tiers.WebTier0,
        yp_utils.DeploySlot(yp_utils.YpMasters.sas, 'sas-web-search.tier0-base', 22000),
        40  # replication
    ),
]

ATTR_BASE_SLOTS = [
    (
        ('multifullbeta1', 'multifullbeta2'),
        tiers.AttributeWebTier0,
        yp_utils.DeploySlot(yp_utils.YpMasters.sas, 'sas-web-search.tier0-attr-base', 22000),
        5  # replication
    ),
]

INVINDEX_SLOTS = [
    (
        ('multifullbeta1', 'multifullbeta2'),
        tiers.InvertedIndexWebTier0,
        yp_utils.DeploySlot(yp_utils.YpMasters.sas, 'sas-web-search.tier0-inverted-index', 19000),
        3  # replication
    ),
]

EMBEDDING_SLOTS = [
    (
        ('multifullbeta1', 'multifullbeta2'),
        tiers.EmbeddingWebTier0,
        yp_utils.DeploySlot(yp_utils.YpMasters.sas, 'sas-web-search.tier0-embedding', 18000),
        6  # replication
    ),
]


INTRANKING_SLOTS = [
    (
        ('multifullbeta1', 'multifullbeta2'),
        yp_utils.DeploySlot(yp_utils.YpMasters.sas, 'sas-web-search.tier0-int-multi', 17000),
        20  # replication
    ),
]

KEYINV_SLOTS = [
    (
        ('multifullbeta1', 'multifullbeta2'),
        tiers.KeyInvWebTier0,
        yp_utils.DeploySlot(yp_utils.YpMasters.sas, 'sas-web-search.tier0-keyinv', 16000),
        15  # replication
    ),
]


MMETA_SLOTS = {
    # SAS
    'multifullbeta1': gencfg_api.GencfgGroup('SAS_MULTI_FULL1_MMETA', sas_topology, mtn=True),
    'multifullbeta2': gencfg_api.GencfgGroup('SAS_MULTI_FULL2_MMETA', sas_topology, mtn=True),
}

SLOTS = MMETA_SLOTS.keys()


def make_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def make_ctrl(readonly):
    yt_client = make_yt_client()
    target_table = get_target_table(readonly, yt_client=yt_client)
    return multibeta_controller.Ctrl(
        'multi_fullbeta',
        target_table,
        multibeta_slots.SlotsCtrl(
            slots.make_deploy_embedding_ctrls(EMBEDDING_SLOTS) +
            slots.make_deploy_intranking_ctrls(INTRANKING_SLOTS) +
            # slots.make_deploy_keyinv_ctrls(KEYINV_SLOTS) +
            slots.make_mmeta_ctrls(MMETA_SLOTS)
        ),
        conf_generator.FullBetaGenerator(
            oldprod2.get_status_table(),
            tables.YappyTable(yt_client, '//home/yappy/fullbeta_controllers'),
            get_configs_table(yt_client=yt_client),
            target_table,
            SLOTS,
        ),
        hard_switch=True
    )


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return tables.ConfigsTable2(
        yt_client, '//home/cajuper/user/web/multibeta/configs2',
        readonly
    )


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/web/multibeta/fullbeta/target',
        configuration.FullBetaConfiguration, readonly
    )


registry.register('web/betas/multi/full', make_ctrl, [registry.ReportsBackends.V2.sas])
