import infra.callisto.controllers.multibeta.controller as controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

import conf_generator
import configuration
from .. import oldprod2
import slots
import tables

default_topology = 'stable-154-r45'

INT_SLOTS = {
    'multiint2': [
        gencfg_api.GencfgGroup('VLA_WEB_REFRESH_UNITED_10DAY_FRA1_INT', default_topology, mtn=True),
    ],
    'multiint3': [
        gencfg_api.GencfgGroup('VLA_WEB_REFRESH_UNITED_10DAY_FRA2_INT', default_topology, mtn=True),
    ],
}

MMETA_SLOTS = {
    'multiint2': gencfg_api.GencfgGroup('VLA_MULTIINT2_MMETA', default_topology, mtn=True),
    'multiint3': gencfg_api.GencfgGroup('VLA_MULTIINT3_MMETA', default_topology, mtn=True),
}


def make_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/web/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/web/multibeta/int/target', configuration.IntBetaConfiguration, readonly=readonly,
    )


def make_ctrl(readonly):
    yt_client = make_yt_client()
    yappy_table = tables.YappyTable(yt_client, '//home/yappy/int_controllers')
    configs_table = get_configs_table(yt_client=yt_client)
    target_table = get_target_table(readonly, yt_client=yt_client)
    conf_gen = conf_generator.IntBetaGenerator(
        oldprod2.get_status_table(),
        yappy_table,
        configs_table,
        target_table,
        MMETA_SLOTS.keys(),
    )
    return controller.Ctrl(
        'multiint',
        target_table,
        multibeta_slots.SlotsCtrl(
            slots.make_int_ctrls(INT_SLOTS) +
            slots.make_mmeta_ctrls(MMETA_SLOTS)
        ),
        conf_gen,
        hard_switch=True
    )


registry.register('web/betas/multi/int', make_ctrl, [registry.ReportsBackends.V2.vla])
