import infra.callisto.controllers.multibeta.controller as controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

import conf_generator
import configuration
from .. import oldprod2
import slots
import tables

vla_default_topology = 'stable-153-r195'
man_default_topology = 'stable-152-r50'

VLA_MMETA_SLOTS = {
    'multimeta{}'.format(i): gencfg_api.GencfgGroup('VLA_MULTIMETA{}_MMETA'.format(i), vla_default_topology, mtn=True)
    for i in range(9, 45)
}

MMETA_SLOTS = {
    'multimeta{}'.format(i): gencfg_api.GencfgGroup('MAN_MULTIMETA{}_MMETA'.format(i), man_default_topology, mtn=True)
    for i in range(1, 9)
}


MMETA_SLOTS.update(VLA_MMETA_SLOTS)


def make_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/web/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or make_yt_client()
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/web/multibeta/mmeta/target', configuration.MmetaBetaConfiguration, readonly=readonly,
    )


def make_ctrl(readonly):
    yt_client = make_yt_client()
    yappy_table = tables.YappyTable(yt_client, '//home/yappy/mmeta_controllers')
    configs_table = get_configs_table(yt_client=yt_client)
    target_table = get_target_table(readonly, yt_client=yt_client)
    conf_gen = conf_generator.MmetaBetaGenerator(
        oldprod2.get_status_table(),
        yappy_table,
        configs_table,
        target_table,
        MMETA_SLOTS.keys(),
    )
    return controller.Ctrl(
        'multi_meta',
        target_table,
        multibeta_slots.SlotsCtrl(slots.make_mmeta_ctrls(MMETA_SLOTS)),
        conf_gen,
        hard_switch=True,
    )


registry.register('web/betas/multi/meta', make_ctrl, [
    registry.ReportsBackends.V2.vla,
])
