import datetime
import logging

import infra.callisto.libraries.yt as yt_utils


class YappyTable(yt_utils.SortedYtTable):
    def _on_init_hook(self):
        self.ensure_table()
        self.ensure_mounted()

    def slot_ids(self):
        request = 'slot_id from [{}] group by slot_id'.format(self.path)
        return [row['slot_id'] for row in self._select_rows(request)]

    def slot_configuration(self, slot_id):
        request = '* from [{}] where slot_id = "{}" order by revision desc limit 1'.format(self.path, slot_id)
        for row in self._select_rows(request):
            return row


class ConfigsTable(yt_utils.SortedYtTable):
    schema = [
        {'name': 'time',                    'type': 'string', 'sort_order': 'ascending'},
        {'name': 'slot_id',                 'type': 'string'},
        {'name': 'mmeta.config',            'type': 'string'},
        {'name': 'mmeta.config_path',       'type': 'string'},
        {'name': 'int.config',              'type': 'string'},
        {'name': 'int.config_path',         'type': 'string'},
        {'name': 'basesearch.config',       'type': 'string'},
        {'name': 'basesearch.config_path',  'type': 'string'},
    ]
    default_config_path = 'all/{short_host}:{port}.cfg'

    def _on_init_hook(self):
        self.ensure_table()
        self.ensure_mounted()

    def slot_ids(self):
        request = 'slot_id from [{}] group by slot_id'.format(self.path)
        return [row['slot_id'] for row in self._select_rows(request)]

    def slot_configs(self, slot_id):
        request = '* from [{}] where slot_id = "{}" order by time desc limit 1'.format(self.path, slot_id)
        for row in self._select_rows(request):
            return row

    def insert_new_configs(
        self,
        slot_id,
        mmeta_config=None,
        int_config=None,
        basesearch_config=None,
        mmeta_config_path=default_config_path,
        int_config_path=default_config_path,
        basesearch_config_path=default_config_path,
    ):
        self._insert_rows([{
            'time': datetime.datetime.now().isoformat(),
            'slot_id': slot_id,
            'mmeta.config': mmeta_config,
            'mmeta.config_path': mmeta_config_path,
            'int.config': int_config,
            'int.config_path': int_config_path,
            'basesearch.config': basesearch_config,
            'basesearch.config_path': basesearch_config_path,
        }])

    def update_slot_configs(
        self,
        slot_id,
        mmeta_config=None,
        int_config=None,
        basesearch_config=None,
        mmeta_config_path=None,
        int_config_path=None,
        basesearch_config_path=None,
    ):
        configs = self.slot_configs(slot_id)
        assert configs
        for key, value in {
            'time': datetime.datetime.now().isoformat(),
            'mmeta.config': mmeta_config,
            'mmeta.config_path': mmeta_config_path,
            'int.config': int_config,
            'int.config_path': int_config_path,
            'basesearch.config': basesearch_config,
            'basesearch.config_path': basesearch_config_path,
        }.items():
            if value:
                configs[key] = value
        self._insert_rows([configs])


class ConfigsTable2(ConfigsTable):
    schema = [
        {'name': 'time',                                'type': 'string', 'sort_order': 'ascending'},
        {'name': 'slot_id',                             'type': 'string'},
        {'name': 'mmeta.config',                        'type': 'string'},
        {'name': 'mmeta.config_path',                   'type': 'string'},
        {'name': 'int.config',                          'type': 'string'},
        {'name': 'int.config_path',                     'type': 'string'},
        {'name': 'basesearch.config',                   'type': 'string'},
        {'name': 'basesearch.config_path',              'type': 'string'},
        {'name': 'embedding.configs.server.resource',   'type': 'string'},
        {'name': 'embedding.configs.server.path',       'type': 'string'},
        {'name': 'embedding.configs.storage.resource',  'type': 'string'},
        {'name': 'embedding.configs.storage.path',      'type': 'string'},
        {'name': 'embedding.configs.replicas.resource', 'type': 'string'},
        {'name': 'embedding.configs.replicas.path',     'type': 'string'},
        {'name': 'invindex.configs.server.resource',    'type': 'string'},
        {'name': 'invindex.configs.server.path',        'type': 'string'},
        {'name': 'invindex.configs.invindex.resource',  'type': 'string'},
        {'name': 'invindex.configs.invindex.path',      'type': 'string'},
        {'name': 'keyinv.configs.server.resource',      'type': 'string'},
        {'name': 'keyinv.configs.server.path',          'type': 'string'},
        {'name': 'keyinv.configs.keyinv.resource',      'type': 'string'},
        {'name': 'keyinv.configs.keyinv.path',          'type': 'string'},
    ]
    default_config_path = 'all/{short_host}:{port}.cfg'

    def _on_init_hook(self):
        self.ensure_table()
        self.ensure_mounted()

    def insert_new_configs(
        self,
        slot_id,
        mmeta_config=None,
        int_config=None,
        basesearch_config=None,
        mmeta_config_path=default_config_path,
        int_config_path=default_config_path,
        basesearch_config_path=default_config_path,
        embedding_configs_server_resource=None,
        embedding_configs_server_path=None,
        embedding_configs_storage_resource=None,
        embedding_configs_storage_path=None,
        embedding_configs_replicas_resource=None,
        embedding_configs_replicas_path=None,
        invindex_configs_server_resource=None,
        invindex_configs_server_path=None,
        invindex_configs_invindex_resource=None,
        invindex_configs_invindex_path=None,
        keyinv_configs_server_resource=None,
        keyinv_configs_server_path=None,
        keyinv_configs_keyinv_resource=None,
        keyinv_configs_keyinv_path=None,
    ):
        self._insert_rows([{
            'time': datetime.datetime.now().isoformat(),
            'slot_id': slot_id,
            'mmeta.config': mmeta_config,
            'mmeta.config_path': mmeta_config_path,
            'int.config': int_config,
            'int.config_path': int_config_path,
            'basesearch.config': basesearch_config,
            'basesearch.config_path': basesearch_config_path,
            'embedding.configs.server.resource': embedding_configs_server_resource,
            'embedding.configs.server.path': embedding_configs_server_path,
            'embedding.configs.storage.resource': embedding_configs_storage_resource,
            'embedding.configs.storage.path': embedding_configs_storage_path,
            'embedding.configs.replicas.resource': embedding_configs_replicas_resource,
            'embedding.configs.replicas.path': embedding_configs_replicas_path,
            'invindex.configs.server.resource': invindex_configs_server_resource,
            'invindex.configs.server.path': invindex_configs_server_path,
            'invindex.configs.invindex.resource': invindex_configs_invindex_resource,
            'invindex.configs.invindex.path': invindex_configs_invindex_path,
            'keyinv.configs.server.resource': keyinv_configs_server_resource,
            'keyinv.configs.server.path': keyinv_configs_server_path,
            'keyinv.configs.keyinv.resource': keyinv_configs_keyinv_resource,
            'keyinv.configs.keyinv.path': keyinv_configs_keyinv_path,
        }])

    def update_slot_configs(
        self,
        slot_id,
        mmeta_config=None,
        int_config=None,
        basesearch_config=None,
        mmeta_config_path=None,
        int_config_path=None,
        basesearch_config_path=None,
        embedding_configs_server_resource=None,
        embedding_configs_server_path=None,
        embedding_configs_storage_resource=None,
        embedding_configs_storage_path=None,
        embedding_configs_replicas_resource=None,
        embedding_configs_replicas_path=None,
        invindex_configs_server_resource=None,
        invindex_configs_server_path=None,
        invindex_configs_invindex_resource=None,
        invindex_configs_invindex_path=None,
        keyinv_configs_server_resource=None,
        keyinv_configs_server_path=None,
        keyinv_configs_keyinv_resource=None,
        keyinv_configs_keyinv_path=None,
    ):
        configs = self.slot_configs(slot_id)
        assert configs
        for key, value in {
            'time': datetime.datetime.now().isoformat(),
            'mmeta.config': mmeta_config,
            'mmeta.config_path': mmeta_config_path,
            'int.config': int_config,
            'int.config_path': int_config_path,
            'basesearch.config': basesearch_config,
            'basesearch.config_path': basesearch_config_path,
            'embedding.configs.server.resource': embedding_configs_server_resource,
            'embedding.configs.server.path': embedding_configs_server_path,
            'embedding.configs.storage.resource': embedding_configs_storage_resource,
            'embedding.configs.storage.path': embedding_configs_storage_path,
            'embedding.configs.replicas.resource': embedding_configs_replicas_resource,
            'embedding.configs.replicas.path': embedding_configs_replicas_path,
            'invindex.configs.server.resource': invindex_configs_server_resource,
            'invindex.configs.server.path': invindex_configs_server_path,
            'invindex.configs.invindex.resource': invindex_configs_invindex_resource,
            'invindex.configs.invindex.path': invindex_configs_invindex_path,
            'keyinv.configs.server.resource': keyinv_configs_server_resource,
            'keyinv.configs.server.path': keyinv_configs_server_path,
            'keyinv.configs.keyinv.resource': keyinv_configs_keyinv_resource,
            'keyinv.configs.keyinv.path': keyinv_configs_keyinv_path,
        }.items():
            if value:
                configs[key] = value
        self._insert_rows([configs])


_log = logging.getLogger(__name__)
