import infra.callisto.controllers.oldprod.controller as oldprod_controller
import infra.callisto.controllers.oldprod.entities as oldprod_entities
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.libraries.yt as yt_utils

DB_TIMESTAMP_RESOURCE_TYPE = {
    oldprod_entities.ResourceType(resource_type='WEB_PRODUCTION_INDEX_STATE_RESOURCE', task_type=None): 'vars.conf',
}

KEYINV_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='KEY_INV_SERVICE_EXECUTABLE', task_type=None): 'httpsearch',
}

INVINDEX_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='INVERTED_INDEX_STORAGE_EXECUTABLE', task_type=None): 'httpsearch',
}

EMBEDDING_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='EMBEDDING_STORAGE_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='DYNAMIC_MODELS_ARCHIVE_L1', task_type=None): 'models.archive',
}

BASESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='BASESEARCH_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='DYNAMIC_MODELS_ARCHIVE_BASE', task_type=None): 'models.archive',
}

INTSEARCH_L1_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='L1_INTSEARCH_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='DYNAMIC_MODELS_ARCHIVE_L1', task_type=None): 'models.archive',
}

INTSEARCH_L2_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='INTSEARCH_EXECUTABLE', task_type=None): 'httpsearch',
}

MIDDLESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='RANKING_MIDDLESEARCH_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
}

BASESEARCH_RESOURCE_TYPES.update(DB_TIMESTAMP_RESOURCE_TYPE)
MIDDLESEARCH_RESOURCE_TYPES.update(DB_TIMESTAMP_RESOURCE_TYPE)


def get_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def get_status_table(readonly=True):
    return oldprod_controller.get_yt_status_table(
        get_yt_client(),
        path='//home/cajuper/user/web/prod/oldprod',
        readonly=readonly
    )


def make_controller(readonly=True):
    service_families = [
        oldprod_controller.ServiceFamily('keyinv', KEYINV_RESOURCE_TYPES, (
            'sas-web-keyinv-resources',
            # 'man-web-keyinv-resources',
            'vla-web-keyinv-resources',
        )),
        oldprod_controller.ServiceFamily('invindex', INVINDEX_RESOURCE_TYPES, (
            'sas-web-invindex-resources',
            # 'man-web-invindex-resources',
            'vla-web-invindex-resources',
        )),
        oldprod_controller.ServiceFamily('embedding', EMBEDDING_RESOURCE_TYPES, (
            'sas-web-embedding-resources',
            # 'man-web-embedding-resources',
            'vla-web-embedding-resources',
        )),
        oldprod_controller.ServiceFamily('base', BASESEARCH_RESOURCE_TYPES, (
            'sas-web-base-resources',
            # 'man-web-base-resources',
            'vla-web-base-resources',
        )),
        oldprod_controller.ServiceFamily('int', INTSEARCH_L1_RESOURCE_TYPES, (
            'sas-web-int-resources',
            # 'man-web-int-resources',
            'vla-web-int-resources',
        )),
        oldprod_controller.ServiceFamily('intl2', INTSEARCH_L2_RESOURCE_TYPES, (
            'sas-web-int-resources',
            # 'man-web-int-resources',
            'vla-web-int-resources',
        )),
        oldprod_controller.ServiceFamily('mmeta', MIDDLESEARCH_RESOURCE_TYPES, (
            'sas_jupiter_mmeta_yp',
            # 'man_jupiter_mmeta_yp',
            'vla_jupiter_mmeta_yp',
        )),
    ]

    db_checker = oldprod_controller.WebDbChecker(
        oldprod_controller.ServiceFamily('db_timestamp', DB_TIMESTAMP_RESOURCE_TYPE, (
            'sas-web-base-resources',
            # 'man-web-base-resources',
            'vla-web-base-resources',
            'sas_jupiter_mmeta_yp',
            # 'man_jupiter_mmeta_yp',
            'vla_jupiter_mmeta_yp',
        ))
    )
    return oldprod_controller.Controller(
        get_status_table(readonly),
        service_families,
        db_checker
    )


def services_table(readonly):
    return oldprod_controller.get_object_status_table(get_yt_client(),
                                                      '//home/cajuper/user/web/prod/services', readonly)


registry.register('web/oldprod2', make_controller, [registry.ReportsBackends.V2.vla])
