import datetime

import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.notify as notify
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.sandbox_utils as sandbox_utils
import infra.callisto.libraries.yt as yt_utils

import chunks.external as external_chunks


LOCATION = 'pip'
default_topology = 'stable-157-r67'
deployer_groups = (
    ('VLA_WEB_BASE_PIP_DEPLOY', default_topology),
)

MMETA_GROUP = 'VLA_WEB_MMETA_PIP'

PLATINUM_BASESEARCH_GROUP = 'VLA_WEB_PLATINUM_JUPITER_BASE_PIP'

TIER0_EMBEDDING_GROUP = 'VLA_WEB_TIER0_EMBEDDING_PIP'
TIER0_INVERTED_INDEX_GROUP = 'VLA_WEB_TIER0_INVERTED_INDEX_PIP'
TIER0_BASESEARCH_GROUP = 'VLA_WEB_TIER0_BASE_PIP'
TIER0_ATTR_BASESEARCH_GROUP = 'VLA_WEB_TIER0_ATTRIBUTE_BASE_PIP'

NAMESPACE_PREFIX = '/web/prod/'
NAMESPACE_PREFIX_YT = '/web/prod/yt/'
SUBRESOURCES = ('dynamic', 'pudge')


def slots_(topology):
    return (
        slots.Slot(
            'Platinum', tier.PlatinumTier0,
            PLATINUM_BASESEARCH_GROUP, 'stable-157-r1284', use_mtn=True),
        slots.WebTier1Slot(
            'WebTier0', tier.WebTier0,
            TIER0_BASESEARCH_GROUP, topology, use_mtn=True),
        slots.WebTier1Slot(
            'AttributeWebTier0', tier.AttributeWebTier0,
            TIER0_ATTR_BASESEARCH_GROUP, topology, use_mtn=True),
        slots.Slot(
            'Mmeta', tier.MsUserData,
            MMETA_GROUP, topology, use_mtn=True),
    )


def yt_slots_(topology):
    return (
        slots.WebTier1Slot(
            'KeyInvWebTier0', tier.KeyInvWebTier0,
            'VLA_WEB_TIER0_KEYINV_PIP', topology, use_mtn=True),
        slots.Slot(
            'EmbeddingWebTier0', tier.EmbeddingWebTier0,
            TIER0_EMBEDDING_GROUP, topology, use_mtn=True),
        slots.Slot(
            'InvertedIndexWebTier0', tier.InvertedIndexWebTier0,
            TIER0_INVERTED_INDEX_GROUP, topology, use_mtn=True, ready_threshold=0.999),
    )


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, '/web/pip/target_v2', readonly)


def get_yt_status_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_status_table(yt_client, '/web/pip/status', readonly)


def make_controller(readonly):
    deploy_ctrl = deploy_controller.make_controller(
        deployer_groups,
        download_args_callback=lambda resource, host: {'max_dl_speed': '150M', 'hardlink': True},
        mtn=True,
    )
    deploy_ctrl.reports_alive_threshold = datetime.timedelta(minutes=30)

    slot_ctrls = search_source.make_slot_controllers(
        slots_(default_topology), deploy_ctrl, namespace_prefix=NAMESPACE_PREFIX
    )
    slot_ctrls.update(search_source.make_slot_controllers(
        yt_slots_(default_topology), deploy_ctrl, namespace_prefix=NAMESPACE_PREFIX_YT
    ))

    slot_ctrls['tier0_chunks_ext'] = external_chunks.Controller(
        external_chunks.location_status('pip'),
        external_chunks.location_target('pip'),
        tier=tier.WebTier0,
        optional=False,
        readonly=readonly,
    )

    return search_source.YtDrivenSourceController(
        name='pip',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly=True),
        status_table=get_yt_status_table(readonly=readonly),
    )


registry.register('web/prod/acceptance', make_controller, [registry.ReportsBackends.V2.vla])
