import infra.callisto.controllers.release as release_ctrl
import infra.callisto.controllers.release.tables as release_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.utils.yp_utils as yp_utils
import infra.callisto.libraries.yt as yt_utils


def get_yt_client(cluster='arnold'):
    return yt_utils.create_yt_client(cluster, use_rpc=True)


def _make_test_controller(readonly, config):
    if config.ServiceTable.TabletCellBundle:
        service_table = release_tables.get_object_status_table(
            get_yt_client(config.ServiceTable.Cluster),
            config.ServiceTable.Path,
            readonly,
            config.ServiceTable.TabletCellBundle
        )
    else:
        service_table = release_tables.get_object_status_table(
            get_yt_client(config.ServiceTable.Cluster),
            config.ServiceTable.Path,
            readonly
        )

    return release_ctrl.ReleaseController(
        service_table,
        config.DeployUnits,
        lock_checker=release_ctrl.make_lock_checher(config.LocksCheck),
        yp_master=yp_utils.YpMasters.man_pre,
        readonly=readonly,
    )


def _make_prod_controller(readonly, config):
    if config.ServiceTable.TabletCellBundle:
        service_table = release_tables.get_object_status_table(
            get_yt_client(config.ServiceTable.Cluster),
            config.ServiceTable.Path,
            readonly,
            config.ServiceTable.TabletCellBundle
        )
    else:
        service_table = release_tables.get_object_status_table(
            get_yt_client(config.ServiceTable.Cluster),
            config.ServiceTable.Path,
            readonly
        )

    return release_ctrl.ReleaseController(
        service_table,
        config.DeployUnits,
        lock_checker=release_ctrl.make_lock_checher(config.LocksCheck),
        readonly=readonly,
    )


registry.register2('common/releases', _make_prod_controller, config_type=release_ctrl.config_pb2.TReleaseControllerConfig)
registry.register2('web/test/releases', _make_test_controller, config_type=release_ctrl.config_pb2.TReleaseControllerConfig)

registry.register2('web/prod/releases', _make_prod_controller, config_type=release_ctrl.config_pb2.TReleaseControllerConfig)

registry.register2('images/prod/releases', _make_prod_controller, config_type=release_ctrl.config_pb2.TReleaseControllerConfig)

registry.register2('video/prod/releases', _make_prod_controller, config_type=release_ctrl.config_pb2.TReleaseControllerConfig)
