# import datetime

import infra.callisto.controllers.shard.ctrl as shardctrl
import infra.callisto.controllers.shard.tables as tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.libraries.yt as yt

from infra.callisto.controllers.shard.utils import make_coordinator, make_instance_providers, make_gencfg_instance_providers, \
    make_plutonium_fs, make_pod_target, make_pod_status


def make_controller(readonly, config):
    local_states = tables.ShardCtrlState(
        yt.create_yt_client(config.ShardCtrlState.Cluster, use_rpc=True),
        config.ShardCtrlState.Path,
        readonly,
        config.ShardCtrlState.TabletCellBundle or 'cajuper'
    )

    chunk_ctrl = shardctrl.ChunkCtrl(
        yt.create_yt_client(config.ChunkCtrl.Cluster, use_rpc=True),
        config.ChunkCtrl.Path,
        config.ChunkCtrl.TabletCellBundle or 'cajuper',
        readonly
    )

    banned_groups = tables.BannedGroupsStub()

    if config.UseReplicaCtl:
        orchestrated_service = shardctrl.ReplicaCtl(
            make_pod_target(config.DeployersTarget, readonly),
            make_pod_status(config.DeployersStatus),
        )
    elif not config.UseBkStat:
        orchestrated_service = shardctrl.RsProxy(
            make_instance_providers(config.RSProxy),
            make_plutonium_fs(config.PlutoniumFS, config.PlutoniumFSErrorClusterProbability),
            make_pod_target(config.DeployersTarget, readonly),
            make_pod_status(config.DeployersStatus),
        )
    else:
        banned_groups = tables.BannedGroups(
            yt.create_yt_client(config.BannedGroups.Cluster, use_rpc=True),
            config.BannedGroups.Path,
            readonly,
            config.BannedGroups.TabletCellBundle or 'cajuper'
        )

        instance_providers = []
        if config.BkStat.PodSet:
            instance_providers.extend(make_instance_providers(config.BkStat.PodSet, cache_for=120))
        if config.BkStat.GencfgGroupSet:
            instance_providers.extend(make_gencfg_instance_providers(config.BkStat.GencfgGroupSet))

        assert instance_providers, "Instance providers not defined"

        orchestrated_service = shardctrl.BkStat(
            instance_providers,
            make_pod_target(config.DeployersTarget, readonly),
            make_pod_status(config.DeployersStatus),
            config.BkStat.MaxNotReadyPods,
            config.BkStat.MaxBadPods,
            config.BkStat.MinMarkBadSeconds,
            config.BkStat.MaxMarkBadSeconds,
            config.BkStat.MinReadyThreshold
        )

    return shardctrl.ShardCtrl(
        namespaces=config.Namespaces,
        chunk_ctrl=chunk_ctrl,
        orchestrated_service=orchestrated_service,
        states=local_states,
        contour_states=tables.ShardCtrlState(
            yt.create_yt_client(config.CoordinatorStates.Cluster, use_rpc=True),
            config.CoordinatorStates.Path,
            readonly,
            config.CoordinatorStates.TabletCellBundle or 'cajuper'
        ),
        realtime_config_table=tables.RealtimeConfig(
            yt.create_yt_client(config.RealtimeConfig.Cluster, use_rpc=True),
            config.RealtimeConfig.Path,
            readonly,
            config.RealtimeConfig.TabletCellBundle or 'cajuper'
        ),
        enable_freeze=config.EnableFreezing or False,
        states_limit=config.StatesLimit or shardctrl.DEFAULT_STATES_LIMIT,
        progress_timeout=config.StateProgressTimeout or shardctrl.STARTUP_INTERVAL,
        banned_groups=banned_groups
    )


registry.register2('saas2/shard', make_controller, sleep_time=4, config_type=shardctrl.TShardConfig)
registry.register2('saas2/coordinator', make_coordinator, sleep_time=4, config_type=shardctrl.TCoordinatorConfig)
