import datetime

import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

import chunks.external as external_chunks

import deploy_params


LOCATION = 'sas'
default_topology = 'stable-157-r5438'
deployer_groups = (
    ('SAS_WEB_DEPLOY', default_topology),
)

TIER0_BASESEARCH_GROUP = 'SAS_WEB_TIER0_BASE'
TIER0_ATTR_BASESEARCH_GROUP = 'SAS_WEB_TIER0_ATTRIBUTE_BASE'
TIER0_ENDPOINT_SET_TEMPLATE = 'sas@sas-web-search.tier0-base.{}'

TIER0_BASESEARCH_HAMSTER_GROUPS = [
    'SAS_WEB_TIER0_ATTRIBUTE_BASE_HAMSTER',
    'SAS_WEB_TIER0_BASE_HAMSTER',
    'SAS_WEB_TIER0_ATTRIBUTE_BASE_MULTI',
    'SAS_WEB_TIER0_BASE_MULTI',
]
TIER0_ENDPOINT_SET_HAMSTER_TEMPLATE = 'sas@sas-web-search.tier0-base.{}.hamster'

NAMESPACE_PREFIX = '/web/prod/'
NAMESPACE_PREFIX_YT = '/web/prod/yt/'
SUBRESOURCES = ('',)


def slots_(topology=default_topology):
    return (
        slots.WebTier1Slot('WebTier0', tier.WebTier0, TIER0_BASESEARCH_GROUP, topology),
        slots.WebTier1Slot('WebTier0Attr', tier.AttributeWebTier0, TIER0_ATTR_BASESEARCH_GROUP, topology),
        slots.GeminiSlot('Gemini', tier.GeminiTier, 'SAS_WEB_GEMINI_BASE', topology),
        slots.Slot('CastorSearchProxy', tier.CastorTier, 'SAS_WEB_GEMINI_SEARCHPROXY_DYN', topology),

        slots.Slot('HamsterPrsMmeta', tier.MsUserData, 'SAS_WEB_MMETA_PRS_HAMSTER', topology),
        slots.Slot('MultibetaFull1Mmeta', tier.MsUserData, 'SAS_MULTI_FULL1_MMETA', topology),
        slots.Slot('MultibetaFull2Mmeta', tier.MsUserData, 'SAS_MULTI_FULL2_MMETA', topology),
    )


def yt_slots_(topology=default_topology):
    return [
        slots.WebTier1Slot(
            'KeyInvWebTier0', tier.KeyInvWebTier0,
            'SAS_WEB_TIER0_KEYINV', topology),
        slots.Slot('EmbeddingWebTier0', tier.EmbeddingWebTier0,
                   'SAS_WEB_TIER0_EMBEDDING', topology),
        slots.Slot('InvertedIndexWebTier0', tier.InvertedIndexWebTier0,
                   'SAS_WEB_TIER0_INVERTED_INDEX', topology),
    ]


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, 'web/prod/sas/target', readonly)


def get_yt_status_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_status_table(yt_client, 'web/prod/sas/status', readonly)


def make_controller(readonly):
    callback = deploy_params.DownloadArgs(gencfg_api.searcher_lookup_agents(*deployer_groups[0]))
    deploy_ctrl = deploy_controller.make_controller(deployer_groups, download_args_callback=callback, mtn=True)
    deploy_ctrl.reports_alive_threshold = datetime.timedelta(hours=6)
    slot_ctrls = search_source.make_slot_controllers(
        slots_(),
        deploy_ctrl,
        deploy_only=True,  # to not intersect with multibeta
        namespace_prefix=NAMESPACE_PREFIX,
    )
    slot_ctrls.update(search_source.make_slot_controllers(
        yt_slots_(),
        deploy_ctrl,
        deploy_only=True,  # to not intersect with multibeta
        namespace_prefix=NAMESPACE_PREFIX_YT))
    slot_ctrls['tier0_chunks_ext'] = external_chunks.Controller(
        external_chunks.location_status('sas'),
        external_chunks.location_target('sas'),
        tier=tier.WebTier0,
        optional=False,
        readonly=readonly,
    )
    return search_source.YtDrivenSourceController(
        name='sas_web',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly),
        status_table=get_yt_status_table(readonly),
    )


registry.register('web/prod/sas', make_controller, [registry.ReportsBackends.V2.sas])
