import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.utils.yp_utils as yp_utils

import deploy_params
import tables
import yp_helper
from yp_helper import DeployUnitInfo


CTRL_ID = 'web/prod/sas_platinum'


def make_ctrl(readonly):
    return yp_helper.make_yp_controller(
        CTRL_ID,
        readonly,
        stage_id='sas-web-search',
        deploy_unit_infos=[
            DeployUnitInfo('sas-web-search.platinum-base-2', tiers.PlatinumTier0, yp_utils.YpMasters.sas),
            DeployUnitInfo('sas-web-search.tier0-attr-base', tiers.AttributeWebTier0, yp_utils.YpMasters.sas, optional_deploy=True, sample_pods=['sas-web-search-tier0-at-wnoqbds5-98']),
            DeployUnitInfo('sas-jupiter-mmeta-hamster-yp', tiers.MsUserData, yp_utils.YpMasters.sas, optional_deploy=True),
            DeployUnitInfo('sas-jupiter-mmeta-yp', tiers.MsUserData, yp_utils.YpMasters.sas, optional_deploy=True),
            DeployUnitInfo('sas-prestable-jupiter-mmeta-yp', tiers.MsUserData, yp_utils.YpMasters.sas, optional_deploy=True),
            DeployUnitInfo('sas-jupiter-mmeta-heater-yp', tiers.MsUserData, yp_utils.YpMasters.sas, optional_deploy=True),
            DeployUnitInfo('sas-itditp-mmeta-yp', tiers.MsUserData, yp_utils.YpMasters.sas, optional_deploy=True),
        ],
        download_args_callback=deploy_params.DownloadArgsYp({})
    )


def get_yt_target_table(readonly):
    return tables.target(CTRL_ID, readonly)


def get_yt_status_table(readonly):
    return tables.status(CTRL_ID, readonly)


registry.register(CTRL_ID, make_ctrl, [registry.ReportsBackends.V2.sas])
