import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.libraries.yt as yt_utils


def target(ctrl_id, readonly):
    return search_source.get_yt_target_table(_yt_client(), '{}/target'.format(ctrl_id), readonly)


def status(ctrl_id, readonly):
    return search_source.get_yt_status_table(_yt_client(), '{}/status'.format(ctrl_id), readonly)


def _yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)
