import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.utils.yp_utils as yp_utils

import deploy_params
import tables

from yp_helper import DeployUnitInfo
import yp_helper

CTRL_ID = 'web/prod/vla_yp'


def make_ctrl(readonly):
    return yp_helper.make_yp_controller(
        CTRL_ID,
        readonly,
        stage_id='vla-web-search',
        deploy_unit_infos=[
            DeployUnitInfo('vla-jupiter-mmeta-hamster-yp', tiers.MsUserData, yp_utils.YpMasters.vla, optional_deploy=True),
            DeployUnitInfo('vla-jupiter-mmeta-heater-yp', tiers.MsUserData, yp_utils.YpMasters.vla, optional_deploy=True),
            DeployUnitInfo('vla-itditp-mmeta-yp', tiers.MsUserData, yp_utils.YpMasters.vla, optional_deploy=True),
            DeployUnitInfo('vla-jupiter-mmeta-yp', tiers.MsUserData, yp_utils.YpMasters.vla, optional_deploy=True),
        ],
        download_args_callback=deploy_params.DownloadArgsYp({})
    )


def get_yt_target_table(readonly):
    return tables.target(CTRL_ID, readonly)


def get_yt_status_table(readonly):
    return tables.status(CTRL_ID, readonly)


registry.register(CTRL_ID, make_ctrl, [registry.ReportsBackends.V2.vla])
