import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.entities as entities
import infra.callisto.controllers.utils.yp_utils as yp_utils

import tables

import logging


class DeployUnitInfo:
    def __init__(self, id, tier, yp_master, optional_deploy=False, sample_pods=None):
        self.id = id
        self.tier = tier
        self.yp_master = yp_master
        self.optional_deploy = optional_deploy
        self.sample_pods = sample_pods


def make_yp_controller(ctrl_id, readonly, stage_id, deploy_unit_infos, download_args_callback=None):
    # Going to become configurable someday
    deployer_port = 10000
    base_port = 80

    deploy_unit_infos = frozenset(deploy_unit_infos)

    pods = {}
    for deploy_unit_info in deploy_unit_infos:
        deploy_unit_pods = yp_utils.read_pods(deploy_unit_info.yp_master, deploy_unit_info.id)
        logging.info('Read %s pods in %s', len(deploy_unit_pods), deploy_unit_info.id)
        pods[deploy_unit_info.id] = deploy_unit_pods

        if deploy_unit_info.sample_pods:
            pods[deploy_unit_info.id] = [pod for pod in pods[deploy_unit_info.id] if pod.id in deploy_unit_info.sample_pods]
            logging.warn('Sampling %s down to %s', deploy_unit_info.id, pods[deploy_unit_info.id])

    deployers = {}
    for deploy_unit_pods in pods.itervalues():
        for pod in deploy_unit_pods:
            deployers[pod.fqdn] = entities.Agent(pod.fqdn, deployer_port)

    deploy_ctrl = deploy_controller.DeployerController(
        deployers,
        download_args_callback=download_args_callback,
        tags={'a_itype_deployer', stage_id}
    )

    slot_ctrls = {}
    for deploy_unit_info in deploy_unit_infos:
        ready_threshold = 1.0 if not deploy_unit_info.optional_deploy else 0.0
        slot_ctrls[deploy_unit_info.id] = slots.make_slot_controller(
            slots.Slot(deploy_unit_info.id, deploy_unit_info.tier, group=None, topology=None, ready_threshold=ready_threshold),
            deploy_ctrl,
            yp_utils.agent_shard_number_mapping(pods[deploy_unit_info.id], base_port, deploy_unit_info.tier),
            deploy_only=True,
            namespace_prefix='/web/prod/',
        )

    return search_source.YtDrivenSourceController(
        name=stage_id,
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=tables.target(ctrl_id, readonly),
        status_table=tables.status(ctrl_id, readonly),
    )
