import infra.callisto.controllers.build.yt_observer as yt_observer
import infra.callisto.controllers.build.source as new_sources
import infra.callisto.controllers.build.task as tasks
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.libraries.memoize as memoize


class _Tasks(object):
    class BuildPlatinumShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.PlatinumTier0

    class BuildWebTier0Shard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.WebTier0
        split_mode = True
        disable_iss_shards = True
        enable_recursive_download = True
        enable_erasure_mode_for = ['arc']

        def produce_config(self):
            config = super(_Tasks.BuildWebTier0Shard, self).produce_config()
            config['args']['register']['attribute_shard'] = {
                'shard_name': self.resource_name.replace('WebTier0', 'AttributeWebTier0'),
                'namespace': self.namespace.replace('WebTier0', 'AttributeWebTier0')
            }
            config['args']['register']['mapping_shard'] = {
                'shard_name': self.resource_name.replace('WebTier0', 'MappingWebTier0'),
                'namespace': self.namespace.replace('WebTier0', 'MappingWebTier0')
            }
            return config

    class BuildWebTier0MiniShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.WebTier0Mini
        split_mode = True
        disable_iss_shards = True
        enable_recursive_download = True
        enable_erasure_mode_for = ['arc']

        def produce_config(self):
            config = super(_Tasks.BuildWebTier0MiniShard, self).produce_config()
            config['args']['register']['attribute_shard'] = {
                'shard_name': self.resource_name.replace('WebTier0Mini', 'AttributeWebTier0Mini'),
                'namespace': self.namespace.replace('WebTier0Mini', 'AttributeWebTier0Mini')
            }
            config['args']['register']['mapping_shard'] = {
                'shard_name': self.resource_name.replace('WebTier0Mini', 'MappingWebTier0Mini'),
                'namespace': self.namespace.replace('WebTier0Mini', 'MappingWebTier0Mini')
            }
            return config

    class BuildWebTier1Shard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.WebTier1
        split_mode = True
        disable_iss_shards = True
        enable_recursive_download = True
        enable_erasure_mode_for = ['arc']

    class BuildWebTier1ErasureShard(BuildWebTier1Shard):
        enable_erasure_mode_for = ['arc']

    class BuildEmbeddingWebTier1Shard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.EmbeddingWebTier1
        make_file = 'embedding_storage_build.mk'

    class BuildInvIndexWebTier1Shard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.InvertedIndexWebTier1
        make_file = 'build_inverted_index_storage.mk'
        disable_iss_shards = True

    class BuildMsUserDataShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.MsUserData
        entry_point = 'JUPITER_BUNDLE/msrun.sh'

    class BuildJudTierShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.JudTier

    class BuildGeminiShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.GeminiTier
        make_file = 'saas_build.mk'

        def produce_config(self):
            cfg = super(_Tasks.BuildGeminiShard, self).produce_config()
            cfg['args']['env'] = {}
            a, b = self.gencfg_tier.shard_number_to_range(self.number)
            cfg['args']['number'] = '{}-{}'.format(a, b)
            return cfg

    class BuildCastorShard(tasks.BuildJupiterShard):
        gencfg_tier = tiers.CastorTier
        make_file = 'saas_build.mk'

        def produce_config(self):
            cfg = super(_Tasks.BuildCastorShard, self).produce_config()
            return cfg


_proxy = 'arnold'
ProductionBaseSource = new_sources.YtTableSource(
    '//home/jupiter/shard_deploy/production_base',
    proxy=_proxy,
)

GeminiSource = new_sources.YtTableSource(
    root='//home/jupiter/shard_deploy/gemini_base',
    proxy=_proxy,
)


_namespace = '/web/prod/'
_tracker_url = 'http://vla-tracker-cajuper.n.yandex-team.ru'
_beta_tracker_url = 'http://beta-tracker-cajuper.n.yandex-team.ru'


PlatinumTier = yt_observer.Observer(
    tier=tiers.PlatinumTier0,
    name='PlatinumTier',
    source=ProductionBaseSource,
    build_task_type=_Tasks.BuildPlatinumShard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)


WebTier0 = yt_observer.Observer(
    tier=tiers.WebTier0,
    name='WebTier0',
    source=ProductionBaseSource,
    build_task_type=_Tasks.BuildWebTier0Shard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)


WebTier0Mini = yt_observer.Observer(
    tier=tiers.WebTier0Mini,
    name='WebTier0Mini',
    source=ProductionBaseSource,
    build_task_type=_Tasks.BuildWebTier0MiniShard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)


KeyInvWebTier0 = yt_observer.Observer(
    tier=tiers.KeyInvWebTier0,
    name='KeyInvWebTier0',
    source=ProductionBaseSource,
    build_task_type=None,
    namespace=_namespace,
    tracker_url=_tracker_url,
)


WebTier1 = yt_observer.Observer(
    tier=tiers.WebTier1,
    name='WebTier1',
    source=ProductionBaseSource,
    build_task_type=_Tasks.BuildWebTier1Shard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)


@memoize.get_cache(records_limit=1)
def get_erasure_test_webtier1():
    return yt_observer.Observer(
        tier=tiers.get_erasure_test_tier(),
        name='ErasureWebTier1',
        source=ProductionBaseSource,
        build_task_type=_Tasks.BuildWebTier1ErasureShard,
        namespace='/web/betas/erasure/',
        tracker_url=_tracker_url,
    )


EmbeddingWebTier1 = yt_observer.Observer(
    tier=tiers.EmbeddingWebTier1,
    name='EmbeddingWebTier1',
    source=ProductionBaseSource,
    build_task_type=_Tasks.BuildEmbeddingWebTier1Shard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)

InvertedIndexWebTier1 = yt_observer.Observer(
    tier=tiers.InvertedIndexWebTier1,
    name='InvertedIndexWebTier1',
    source=ProductionBaseSource,
    build_task_type=_Tasks.BuildInvIndexWebTier1Shard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)

EmbeddingWebTier0 = yt_observer.Observer(
    tier=tiers.EmbeddingWebTier0,
    name='EmbeddingWebTier0',
    source=ProductionBaseSource,
    build_task_type=None,
    namespace=_namespace,
    tracker_url=_tracker_url,
)

InvertedIndexWebTier0 = yt_observer.Observer(
    tier=tiers.InvertedIndexWebTier0,
    name='InvertedIndexWebTier0',
    source=ProductionBaseSource,
    build_task_type=None,
    namespace=_namespace,
    tracker_url=_tracker_url,
)

MsUserDataTier = yt_observer.Observer(
    tier=tiers.MsUserData,
    name='MsUserDataTier',
    source=new_sources.YtTableSource(
        root='//home/jupiter/shard_deploy/production_middlesearch_shard',
        proxy=_proxy,
    ),
    build_task_type=_Tasks.BuildMsUserDataShard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)

JudTier = yt_observer.Observer(
    tier=tiers.JudTier,
    name='JudTier',
    source=ProductionBaseSource,
    build_task_type=_Tasks.BuildJudTierShard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)

Gemini = yt_observer.Observer(
    tier=tiers.GeminiTier,
    name='Gemini',
    source=GeminiSource,
    build_task_type=_Tasks.BuildGeminiShard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)

Castor = yt_observer.Observer(
    tier=tiers.CastorTier,
    name='Castor',
    source=GeminiSource,
    build_task_type=_Tasks.BuildCastorShard,
    namespace=_namespace,
    tracker_url=_tracker_url,
)
