import logging

import infra.callisto.controllers.multibeta.generator as multibeta_generator

import configuration


class BaseBetaGenerator(multibeta_generator.GeneratorProdTable):
    def __init__(self, *args, **kwargs):
        super(BaseBetaGenerator, self).__init__(*args, **kwargs)
        self._target_index_state = None

    def _prod_common_config(self):
        cfg = self._prod_table.last_status()
        return _convert_prod_common_config_to_yappy(cfg.config) if cfg.config else {}

    def _eval_target(self, yappy_conf, prod_conf, configs):
        return configuration.BaseBetaConfiguration(
            yappy_conf['revision'],
            str(self._target_index_state.timestamp),
            _eval_mmeta(yappy_conf, prod_conf, configs),
            _eval_base(yappy_conf, prod_conf, configs),
        )

    def set_target_index_state(self, target_state):
        self._target_index_state = target_state

    def execute(self):
        if self._target_index_state:
            super(BaseBetaGenerator, self).execute()
        else:
            logging.warning('Skip execute due to target_index_state is %s', self._target_index_state)


class MmetaBetaGenerator(multibeta_generator.GeneratorProdTable):
    def _eval_target(self, yappy_conf, prod_conf, configs):
        return configuration.MmetaBetaConfiguration(
            yappy_conf['revision'],
            _eval_mmeta(yappy_conf, prod_conf, configs),
        )

    def _prod_common_config(self):
        cfg = self._prod_table.last_status()
        return _convert_prod_common_config_to_yappy(cfg.config) if cfg.config else {}


def _eval_mmeta(yappy_conf, prod_conf, configs):
    return configuration.MmetaConfiguration(
        multibeta_generator.get_resource('mmeta.executable', yappy_conf, prod_conf),
        multibeta_generator.get_resource('mmeta.models', yappy_conf, prod_conf),
        multibeta_generator.get_resource('mmeta.rearrange', yappy_conf, prod_conf),
        configs['mmeta.config'],
        configs['mmeta.config_path'],
    )


def _eval_base(yappy_conf, prod_conf, configs):
    return configuration.BaseConfiguration(
        multibeta_generator.get_resource('basesearch.executable', yappy_conf, prod_conf),
        multibeta_generator.get_resource('basesearch.models', yappy_conf, prod_conf),
        multibeta_generator.get_resource('basesearch.static_models', yappy_conf, prod_conf),
        multibeta_generator.get_resource('basesearch.config', yappy_conf, prod_conf),
    )


def _convert_prod_common_config_to_yappy(cfg):
    base, mmeta = cfg['base'], cfg['mmeta']
    return {
        'basesearch.executable': base['httpsearch'],
        'basesearch.models': base['models.archive'],
        'basesearch.static_models': base['static_models'],
        'basesearch.config': base['config'],
        'mmeta.executable': mmeta['httpsearch'],
        'mmeta.models': mmeta['models.archive'],
        'mmeta.rearrange': mmeta['rearrange'],
    }
