import infra.callisto.controllers.multibeta.controller as controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

import conf_generator
import configuration
import oldprod2_news
import slots
import tables


default_topology = 'stable-142-r1040'


MMETA_SLOTS = {
    'news_multimeta1': gencfg_api.GencfgGroup('VLA_SAAS_CLOUD_NEWS_QUICK_BETA3_MMETA', default_topology, mtn=True),
    'news_multimeta2': gencfg_api.GencfgGroup('VLA_SAAS_CLOUD_NEWS_QUICK_BETA4_MMETA', default_topology, mtn=True),
}


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/saas/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/saas/multibeta/news_mmeta/target',
        configuration.MmetaBetaConfiguration,
        readonly=readonly,
    )


def make_ctrl(readonly):
    yt_client = yt_utils.create_yt_client('arnold')
    yappy_table = tables.YappyTable(yt_client, '//home/yappy/saas_news_mmeta_controllers')
    configs_table = get_configs_table(yt_client=yt_client)
    target_table = get_target_table(readonly, yt_client=yt_client)
    conf_gen = conf_generator.MmetaBetaGenerator(
        oldprod2_news.get_status_table(),
        yappy_table,
        configs_table,
        target_table,
        MMETA_SLOTS.keys(),
    )
    return controller.Ctrl(
        'saas_betas_news_meta',
        target_table,
        multibeta_slots.SlotsCtrl(slots.make_mmeta_ctrls(MMETA_SLOTS)),
        conf_gen,
        hard_switch=True,
    )


registry.register('saas/betas/news/meta', make_ctrl, [registry.ReportsBackends.V2.vla])
