import infra.callisto.controllers.oldprod.controller as oldprod_controller
import infra.callisto.controllers.oldprod.entities as oldprod_entities
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.libraries.yt as yt_utils


BASESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='RTYSERVER', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='DYNAMIC_MODELS_ARCHIVE_BASE', task_type=None): 'models.archive',
    oldprod_entities.ResourceType(resource_type='RTYSERVER_MODELS', task_type=None): 'static_models',
    oldprod_entities.ResourceType(resource_type='SAAS_RTYSERVER_CONFIGS_BUNDLE', task_type=None): 'config',
}

MIDDLESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='ARCADIA_PROJECT', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='NEWS_DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
    oldprod_entities.ResourceType(resource_type='QUICK_REARRANGE_RULES_DATA', task_type=None): 'rearrange',
}


def get_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def get_status_table(readonly=True):
    return oldprod_controller.get_yt_status_table(
        get_yt_client(),
        path='//home/cajuper/user/saas/prod/oldprod_news',
        readonly=readonly
    )


def make_controller(readonly=True):
    service_families = [
        oldprod_controller.ServiceFamily('base', BASESEARCH_RESOURCE_TYPES, [
            'saas_news_quick_production_base',
        ]),
        oldprod_controller.ServiceFamily('mmeta', MIDDLESEARCH_RESOURCE_TYPES, [
            'saas_news_quick_production_mmeta',
        ]),
    ]

    return oldprod_controller.Controller(
        get_status_table(readonly),
        service_families,
    )


registry.register('saas/news/oldprod2', make_controller, [registry.ReportsBackends.V2.vla])
