import infra.callisto.controllers.multibeta.slots as slots
import infra.callisto.controllers.multibeta.observed as observed
import infra.callisto.controllers.utils.gencfg_api as gencfg_api


class RtyserverCtrl(slots.RtyserverCtrl):
    def _generate_configuration_config(self, agent, configuration):
        return {
            'revision': configuration.revision,
            'conf_hash': hash(configuration),
            'container': self._porto_properties,
            'index_timestamp': configuration.index_timestamp,
            'resources': [
                slots.resolve_resource('basesearch.executable', configuration.base.executable),
                slots.resolve_resource('basesearch.models', configuration.base.models),
                slots.resolve_resource('basesearch.static_models', configuration.base.static_models),
                slots.resolve_resource('basesearch.cfg', configuration.base.config),
            ],
        }


class MmetaCtrl(slots.MmetaCompCtrl):
    def __init__(self, slots_agents, use_dynamic_ports=False, ratio=0.75):
        super(MmetaCtrl, self).__init__(slots_agents, use_dynamic_ports=False, ratio=0.75)
        self._observed = observed.IntObserved(slots_agents, ratio)  # Because saas mmetas are shardless. Just like ints.

    def _generate_configuration_config(self, agent, configuration):
        config = super(MmetaCtrl, self)._generate_configuration_config(agent, configuration)
        config['resources'].append(
            slots.resolve_resource('mmeta.rearrange', configuration.mmeta.rearrange)
        )

        return config


def make_rtyserver_ctrls(rtyserver_slots):
    return [
        RtyserverCtrl(
            tier,
            gencfg_api.get_agent_shard_number_mapping([group]),
            slots_ids=list(slots_ids),
            tags={group.name},
        )
        for slots_ids, descr in rtyserver_slots.iteritems() for tier, group in descr.iteritems()
    ]


def make_mmeta_ctrls(mmeta_slots, ratio=0.75):
    return [
        MmetaCtrl(
            {
                slot_id: gencfg_api.get_agents([group])
                for slot_id, group in mmeta_slots.iteritems()
            },
            ratio=ratio
        )
    ]
