import infra.callisto.controllers.multibeta.controller as controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.controllers.utils.yp_utils as yp_utils
import infra.callisto.libraries.yt as yt_utils

from .. import oldprod2
import conf_generator
import configuration
import slots
import tables


Tag = 'stable-153-r170'


MMETA_SLOTS = {
    'video_multibeta1': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA1_MMETA', Tag, mtn=False),
    'video_multibeta2': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA2_MMETA', Tag, mtn=False),
    'video_multibeta3': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA3_MMETA', Tag, mtn=False),
    'video_multibeta4': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA4_MMETA', Tag, mtn=False),
    # 'video_multibeta5': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA5_MMETA', Tag, mtn=False),
    'video_multibeta6': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA6_MMETA', Tag, mtn=False),
    'video_multibeta7': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA7_MMETA', Tag, mtn=False),
    'video_multibeta8': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIBETA8_MMETA', Tag, mtn=False),
}

SLOTS = tuple(MMETA_SLOTS.keys())

DEPLOY_SLOTS = [
    (SLOTS,
     tiers.VideoPlatinum,
     yp_utils.DeploySlot(yp_utils.YpMasters.vla, 'vla-video-search.vla-video-platinum-base', 20000)),
    (SLOTS,
     tiers.VideoTier0,
     yp_utils.DeploySlot(yp_utils.YpMasters.vla, 'vla-video-search.vla-video-tier0-base', 20000)),
]


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/video/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/video/multibeta/base/target',
        configuration.BaseBetaConfiguration, readonly=readonly,
    )


def make_ctrl(readonly):
    yt_client = yt_utils.create_yt_client('arnold')
    target_table = get_target_table(readonly, yt_client=yt_client)
    conf_gen = conf_generator.BaseBetaGenerator(
        oldprod2.get_status_table(),
        tables.YappyTable(yt_client, '//home/yappy/video_base_controllers', readonly=True),
        get_configs_table(readonly, yt_client=yt_client),
        target_table,
        SLOTS,
    )
    return controller.Ctrl(
        'video_multi_beta',
        target_table,
        multibeta_slots.SlotsCtrl(
            slots.make_deploy_ctrls(DEPLOY_SLOTS) +
            slots.make_mmeta_ctrls(MMETA_SLOTS, ratio=0.3)
        ),
        conf_gen,
        hard_switch=True,
    )


registry.register('video/betas/multi/base', make_ctrl, [registry.ReportsBackends.V2.vla])
