import infra.callisto.controllers.utils.nested_obj as nested_obj


class MmetaConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('models', nested_obj.String),
        ('config', nested_obj.String),
        ('config_path', nested_obj.String),
    )


class BasesearchConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('models', nested_obj.String),
        ('config', nested_obj.String),
        ('config_path', nested_obj.String),
    )


class RtyserverConfiguration(nested_obj.NestedObject):
    fields = (
        ('executable', nested_obj.String),
        ('models', nested_obj.String),
        ('static_models', nested_obj.String),
        ('config', nested_obj.String),
    )


class _Configuration(nested_obj.NestedObject):
    def __str__(self):
        return '{}({})'.format(self.__class__.__name__, self.revision)


class QuickBetaConfiguration(_Configuration):
    fields = (
        ('revision', nested_obj.Integer),
        ('index_timestamp', nested_obj.String),
        ('quick_base', RtyserverConfiguration),
    )


class BaseBetaConfiguration(_Configuration):
    fields = (
        ('revision', nested_obj.Integer),
        ('mmeta', MmetaConfiguration),
        ('base', BasesearchConfiguration),
    )


class MmetaBetaConfiguration(_Configuration):
    fields = (
        ('revision', nested_obj.Integer),
        ('mmeta', MmetaConfiguration),
    )
