import infra.callisto.controllers.multibeta.controller as controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

from .. import oldprod2
import conf_generator
import configuration
import slots
import tables


default_topology = 'stable-158-r211'

MMETA_SLOTS = {
    'video_multimeta1': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA1_MMETA', default_topology, mtn=False),
    'video_multimeta2': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA2_MMETA', default_topology, mtn=False),
    'video_multimeta3': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA3_MMETA', default_topology, mtn=False),
    'video_multimeta4': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA4_MMETA', default_topology, mtn=False),
    'video_multimeta5': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA5_MMETA', default_topology, mtn=False),
    'video_multimeta6': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA6_MMETA', default_topology, mtn=False),
    'video_multimeta7': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA7_MMETA', default_topology, mtn=False),
    'video_multimeta8': gencfg_api.GencfgGroup('VLA_VIDEO_MULTIMETA8_MMETA', default_topology, mtn=False),
}


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/video/multibeta/configs', readonly)


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/video/multibeta/meta/target', configuration.MmetaBetaConfiguration, readonly=readonly,
    )


def make_ctrl(readonly):
    yt_client = yt_utils.create_yt_client('arnold')
    target_table = get_target_table(readonly, yt_client=yt_client)
    conf_gen = conf_generator.MmetaBetaGenerator(
        oldprod2.get_status_table(),
        tables.YappyTable(yt_client, '//home/yappy/video_mmeta_controllers', readonly=True),
        get_configs_table(readonly, yt_client),
        target_table,
        MMETA_SLOTS.keys(),
    )
    return controller.Ctrl(
        'video_multi_meta',
        target_table,
        multibeta_slots.SlotsCtrl(slots.make_mmeta_ctrls(MMETA_SLOTS)),
        conf_gen,
        hard_switch=True,
    )


registry.register('video/betas/multi/meta', make_ctrl, [registry.ReportsBackends.V2.vla])
