import logging

import infra.callisto.controllers.deployer.controller as deploy_controller
import infra.callisto.controllers.multibeta.controller as multibeta_controller
import infra.callisto.controllers.multibeta.slots as multibeta_slots
import infra.callisto.controllers.multibeta.tables as multibeta_tables
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tiers
import infra.callisto.controllers.slots.controllers as slots_controllers
import infra.callisto.controllers.slots.slot as slots_slot
import infra.callisto.controllers.slots.state as slots_state
import infra.callisto.controllers.utils.funcs as funcs_utils
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

from .. import oldprod2
import conf_generator
import configuration
import slots
import tables


Tag = 'stable-149-r50'

DEPLOYER_GROUP = gencfg_api.GencfgGroup(
    'VLA_VIDEO_SAAS_QUICK_MULTIBETA_DEPLOY',
    Tag,
    mtn=True
)

RTYSERVER_SLOTS = {
    ('video_multibeta_quick6',): {
        tiers.VideoSaasQuickTier: gencfg_api.GencfgGroup('VLA_VIDEO_SAAS_QUICK_MULTIBETA6_BASE', Tag, mtn=True),
    },
    ('video_multibeta_quick8',): {
        tiers.VideoSaasQuickTier: gencfg_api.GencfgGroup('VLA_VIDEO_SAAS_QUICK_MULTIBETA8_BASE', Tag, mtn=True),
    },
}


def get_target_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return multibeta_tables.TargetTable(
        yt_client, '//home/cajuper/user/video/multibeta/quick/target', configuration.QuickBetaConfiguration, readonly,
    )


def get_configs_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return tables.ConfigsTable(yt_client, '//home/cajuper/user/video/multibeta/configs', readonly)


def get_yappy_table(readonly=True, yt_client=None):
    yt_client = yt_client or yt_utils.create_yt_client('arnold')
    return tables.YappyTable(yt_client, '//home/yappy/video_quick_controllers', readonly=readonly)


class Ctrl(multibeta_controller.Ctrl):
    def __init__(self, name, slots_table, slots_ctrl, conf_gen, deployers_proxy, state_table):
        super(Ctrl, self).__init__(name, slots_table, slots_ctrl, conf_gen)
        self._deployers = deployers_proxy
        self._state_table = state_table
        self.register(deployers_proxy._deploy_ctrl)

    def execute(self):
        target_states = set()

        last_state = self._state_table.last_state()
        target_states.add(slots_state.SlotState(funcs_utils.yt_state_to_timestamp(last_state['State'])))
        logging.debug('Last deploy state %s', target_states)

        for slot_id in self._slots_ctrl.slots_ids:
            configurations = self._slots_table.top_n(slot_id, 1)
            target_states.update(set(slots_state.SlotState(config.index_timestamp) for config in configurations))
            logging.debug('%s slot states %s', slot_id, target_states)

        self._deployers.target_states = target_states

        logging.debug('Observed states %s', self._deployers.observed_states)

        if self._deployers.observed_states:
            new_deployed_state = sorted(self._deployers.observed_states).pop()
            logging.debug('Set state for searchers %s', new_deployed_state)
            self._conf_gen.set_target_index_state(new_deployed_state)

            for slot_id in self._slots_ctrl.slots_ids:
                configurations = self._slots_table.top_n(slot_id, 1)
                self._slots_ctrl.set_slot_target(slot_id, configurations)


def _make_agent_shard_mapping():
    return gencfg_api.get_agent_shard_number_mapping([
        group
        for descr in RTYSERVER_SLOTS.itervalues()
        for group in descr.itervalues()
    ])


def make_ctrl(readonly):
    yt_client = yt_utils.create_yt_client('arnold')
    yappy_table = get_yappy_table(readonly=True, yt_client=yt_client)
    config_table = get_configs_table(readonly=True, yt_client=yt_client)
    target_table = get_target_table(readonly=readonly, yt_client=yt_client)

    return Ctrl(
        'multi_quick_beta',
        target_table,
        multibeta_slots.SlotsCtrl(
            slots.make_rtyserver_ctrls(RTYSERVER_SLOTS)
        ),
        conf_generator.QuickBetaGenerator(
            oldprod2.get_status_table(),
            yappy_table,
            config_table,
            target_table,
            [
                slot
                for rtyslots in RTYSERVER_SLOTS.iterkeys()
                for slot in rtyslots
            ]
        ),
        slots_controllers.DeployerProxy(
            slots_slot.Slot('vla-slot', tiers.VideoSaasQuickTier, None, None),  # BASE_GROUP, Tag),
            deploy_controller.make_deployer_controller2(
                [DEPLOYER_GROUP],
                download_args_callback=lambda resource, host: {'max_dl_speed': '25M'},
            ),
            _make_agent_shard_mapping()
        ),
        state_table=tables.IndexStateTable(yt_client, '//home/videoindex/ultra/frozen_shards'),
    )


registry.register('video/betas/multi/quick', make_ctrl, [registry.ReportsBackends.V2.vla])
