import infra.callisto.controllers.oldprod.controller as oldprod_controller
import infra.callisto.controllers.oldprod.entities as oldprod_entities
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.libraries.yt as yt_utils

BASESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='VIDEOSEARCH_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='VIDEO_DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
}

INTSEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='INTSEARCH_EXECUTABLE', task_type=None): 'httpsearch',
}

MIDDLESEARCH_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='VIDEO_RANKING_MIDDLESEARCH_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='VIDEO_MIDDLE_DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
}

DB_TIMESTAMP_RESOURCE_TYPE = {
    oldprod_entities.ResourceType(resource_type='VIDEO_PRODUCTION_INDEX_STATE_RESOURCE', task_type=None): 'vars.conf',
}

VIDEO_QUICK_RESOURCE_TYPES = {
    oldprod_entities.ResourceType(resource_type='VIDEORTYSERVER_EXECUTABLE', task_type=None): 'httpsearch',
    oldprod_entities.ResourceType(resource_type='VIDEO_DYNAMIC_MODELS_ARCHIVE', task_type=None): 'models.archive',
    oldprod_entities.ResourceType(resource_type='RTYSERVER_MODELS', task_type=None): 'static_models',
    oldprod_entities.ResourceType(resource_type='VIDEOQUICK_CONFIGS_BUNDLE', task_type=None): 'config',
}


def get_yt_client():
    return yt_utils.create_yt_client('arnold', use_rpc=True)


def get_status_table(readonly=True):
    return oldprod_controller.get_yt_status_table(
        get_yt_client(),
        path='//home/cajuper/user/video/prod/oldprod',
        readonly=readonly
    )


def make_controller(readonly=True):
    service_families = [
        oldprod_controller.ServiceFamily('base', BASESEARCH_RESOURCE_TYPES, (
            # 'man-video-base-resources',
            'sas-video-base-resources',
            'vla-video-base-resources',
        )),
        oldprod_controller.ServiceFamily('int', INTSEARCH_RESOURCE_TYPES, (
            # 'man_video_int',
            'sas_video_int',
            'vla_video_int',
        )),
        oldprod_controller.ServiceFamily('mmeta', MIDDLESEARCH_RESOURCE_TYPES, (
            # 'production_vidmmeta_man',
            'production_vidmmeta_sas',
            'production_vidmmeta_vla',
        )),
        oldprod_controller.ServiceFamily('quick_base', VIDEO_QUICK_RESOURCE_TYPES, (
            # 'saas_refresh_production_video_base_man',
            'saas_refresh_production_video_base_sas',
            'saas_refresh_production_video_base_vla',
        )),
    ]

    db_checker = oldprod_controller.WebDbChecker(
        oldprod_controller.ServiceFamily('db_timestamp', DB_TIMESTAMP_RESOURCE_TYPE, (
            # 'man-video-base-resources',
            'sas-video-base-resources',
            'vla-video-base-resources',
            # 'production_vidmmeta_man',
            'production_vidmmeta_sas',
            'production_vidmmeta_vla',
        ))
    )
    return oldprod_controller.Controller(
        get_status_table(readonly),
        service_families,
        db_checker
    )


registry.register('video/oldprod2', make_controller, [registry.ReportsBackends.V2.vla])
