import datetime
import time

import infra.callisto.controllers.utils.funcs as funcs_utils
import infra.callisto.libraries.yt as yt_utils


class _StateTable(yt_utils.SortedYtTable):
    schema = [
        {"name": "ts", "type": "uint64", "sort_order": "ascending"},
        {"name": "state", "type": "string"},
    ]

    def head(self):
        request = "* from [{}] order by ts desc limit 1".format(self._path)
        for row in self._select_rows(request):
            return datetime.datetime.fromtimestamp(row['ts']), funcs_utils.yt_state_to_timestamp(row['state'])

    def write(self, search_ts):
        assert not self._readonly, 'readonly mode'
        row = {
            'ts': int(time.time()),
            'state': funcs_utils.timestamp_to_yt_state(search_ts)
        }
        self._insert_rows([row])


def _get_yt_state_table(path, readonly):
    yt_client = yt_utils.create_yt_client('arnold')
    table_path = '//home/videoindex/full/index/deployed' + path
    return _StateTable(yt_client, table_path, readonly)


def get_custom_pip_state_table(readonly):
    return _get_yt_state_table('/pip', readonly)


def get_custom_prod_state_table(readonly):
    return _get_yt_state_table('/production', readonly)
