import functools

import infra.callisto.controllers.deployer2.controller as deploy_controller
import infra.callisto.controllers.sdk.registry as registry
import infra.callisto.controllers.sdk.tier as tier
import infra.callisto.controllers.search_source.controller as search_source
import infra.callisto.controllers.slots as slots
import infra.callisto.controllers.utils.gencfg_api as gencfg_api
import infra.callisto.libraries.yt as yt_utils

from infra.callisto.controllers.user.jupiter.chunks.external import Controller as ext_chunks_controller

import deploy_params
import sandbox_tasks
import tier_chunks

default_topology = 'stable-154-r2996'
deployer_groups = (
    ('VLA_VIDEO_DEPLOY', default_topology),
)

LOCATION = 'vla'
NAMESPACE_PREFIX = '/video/prod/'
NAMESPACE_PREFIX_YT = '/video/prod/yt'
SUBRESOURCES = ('video',)

PLATINUM_BASESEARCH_GROUP = 'VLA_VIDEO_PLATINUM_BASE'
PLATINUM_REMOTE_STORAGE_GROUP = 'VLA_VIDEO_REMOTE_STORAGE_BASE'
PLATINUM_ENDPOINT_SET_TEMPLATE = 'vla@vla-video-search.vla-video-platinum-base.{}'


def slots_(topology=default_topology):
    return [
        slots.Slot('VideoPlatinum', tier.VideoPlatinum, PLATINUM_BASESEARCH_GROUP, topology),
        slots.Slot('VideoTier0', tier.VideoTier0, 'VLA_VIDEO_TIER0_BASE', topology),
        slots.Slot('PlatinumEmbedding', tier.VideoEmbeddingPlatinum, 'VLA_VIDEO_PLATINUM_EMBEDDING', topology, use_mtn=True),
        slots.Slot('PlatinumInverted', tier.VideoInvertedPlatinum, 'VLA_VIDEO_PLATINUM_INVERTED_INDEX', topology, use_mtn=True),
        slots.Slot('Tier0Embedding', tier.VideoEmbeddingTier0, 'VLA_VIDEO_TIER0_EMBEDDING', topology, use_mtn=True),
        slots.Slot('Tier0Inverted', tier.VideoInvertedTier0, 'VLA_VIDEO_TIER0_INVERTED_INDEX', topology, use_mtn=True),
    ]


def get_yt_target_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_target_table(yt_client, 'video/prod/vla/target', readonly)


def get_yt_status_table(readonly):
    yt_client = yt_utils.create_yt_client('arnold', use_rpc=True)
    return search_source.get_yt_status_table(yt_client, 'video/prod/vla/status', readonly)


def make_controller(readonly):
    callback = deploy_params.DownloadArgs(
        deployer_instances=gencfg_api.searcher_lookup_agents(*deployer_groups[0], mtn=True),
    )
    deploy_ctrl = deploy_controller.make_controller(deployer_groups, download_args_callback=callback, mtn=True)
    slot_ctrls = search_source.make_slot_controllers(
        slots_(),
        deploy_ctrl,
        deploy_only=True,
        namespace_prefix=NAMESPACE_PREFIX,
    )
    slot_ctrls['platinum_chunks'] = tier_chunks.make_chunks_ctrl(
        location=LOCATION,
        deploy_ctrl=deploy_ctrl,
        namespace_prefix=NAMESPACE_PREFIX_YT,
        remote_storage_group=(PLATINUM_REMOTE_STORAGE_GROUP, default_topology),
        readonly=readonly,
        subresources=SUBRESOURCES,
        generation_max_space_share=0.5,
        configs_generator=functools.partial(
            sandbox_tasks.generate_rs_configs_task,
            location=LOCATION,
            topology=default_topology,
            tier=tier.VideoPlatinum,
            namespace_prefix=NAMESPACE_PREFIX_YT,
            subresources=SUBRESOURCES,
            rs_group=PLATINUM_REMOTE_STORAGE_GROUP,
            basesearch_groups=[PLATINUM_BASESEARCH_GROUP],
            endpoint_set_template=PLATINUM_ENDPOINT_SET_TEMPLATE,
            readonly=readonly
        ),
        tier=tier.VideoPlatinum,
    )
    slot_ctrls['platinum_chunks_ext'] = ext_chunks_controller(
        '//home/cajuper/user/video/prod/chunks/ctl/vla/chunks_status',
        '//home/cajuper/user/video/prod/chunks/ctl/vla/chunks_target',
        tier=tier.VideoPlatinum,
        optional=False,
        readonly=readonly,
    )

    return search_source.YtDrivenSourceController(
        name='vla_video',
        slots_=slot_ctrls,
        deployer=deploy_ctrl,
        target_table=get_yt_target_table(readonly),
        status_table=get_yt_status_table(readonly),
    )


registry.register('video/prod/vla', make_controller, [registry.ReportsBackends.V2.vla])
