import infra.callisto.controllers.build.yt_observer as yt_observer
import infra.callisto.controllers.build.source as sources
import infra.callisto.controllers.build.task as tasks
import infra.callisto.controllers.sdk.tier as tiers

VLA_TRACKER = 'http://vla-tracker-cajuper.n.yandex-team.ru'


class _Tasks(object):
    class BuildVideoShard(tasks.BuildShardIncremental):
        entry_point = 'bundle/shard_builder_jupiter.sh'
        bundle_type = 'video'

    class BuildVideoTier0Shard(BuildVideoShard):
        gencfg_tier = tiers.VideoTier0

    class BuildVideoPlatinumShard(BuildVideoShard):
        gencfg_tier = tiers.VideoPlatinum

    class BuildVideoEmbeddingTier0Shard(BuildVideoShard):
        gencfg_tier = tiers.VideoEmbeddingTier0

    class BuildVideoEmbeddingPlatinumShard(BuildVideoShard):
        gencfg_tier = tiers.VideoEmbeddingPlatinum

    class BuildVideoInvertedTier0Shard(BuildVideoShard):
        gencfg_tier = tiers.VideoInvertedTier0

    class BuildVideoInvertedPlatinumShard(BuildVideoShard):
        gencfg_tier = tiers.VideoInvertedPlatinum


class Sources(object):
    VideoProd = sources.YtTableSource(
        root='//home/videoindex/full/index/shard_deploy/production_base',
        proxy='arnold',
        is_table_dynamic=True,
    )


Platinum = yt_observer.Observer(
    tier=tiers.VideoPlatinum,
    name='VideoPlatinum',
    source=Sources.VideoProd,
    build_task_type=_Tasks.BuildVideoPlatinumShard,
    tracker_url=VLA_TRACKER,
    namespace='/video/prod/',
)

Tier0 = yt_observer.Observer(
    tier=tiers.VideoTier0,
    name='VideoTier0',
    source=Sources.VideoProd,
    build_task_type=_Tasks.BuildVideoTier0Shard,
    tracker_url=VLA_TRACKER,
    namespace='/video/prod/',
)

EmbeddingPlatinum = yt_observer.Observer(
    tier=tiers.VideoEmbeddingPlatinum,
    name='VideoEmbeddingPlatinum',
    source=Sources.VideoProd,
    build_task_type=_Tasks.BuildVideoEmbeddingPlatinumShard,
    tracker_url=VLA_TRACKER,
    namespace='/video/prod/',
)

EmbeddingTier0 = yt_observer.Observer(
    tier=tiers.VideoEmbeddingTier0,
    name='VideoEmbeddingTier0',
    source=Sources.VideoProd,
    build_task_type=_Tasks.BuildVideoEmbeddingTier0Shard,
    tracker_url=VLA_TRACKER,
    namespace='/video/prod/',
)

InvertedPlatinum = yt_observer.Observer(
    tier=tiers.VideoInvertedPlatinum,
    name='VideoInvertedPlatinum',
    source=Sources.VideoProd,
    build_task_type=_Tasks.BuildVideoInvertedPlatinumShard,
    tracker_url=VLA_TRACKER,
    namespace='/video/prod/',
)

InvertedTier0 = yt_observer.Observer(
    tier=tiers.VideoInvertedTier0,
    name='VideoInvertedTier0',
    source=Sources.VideoProd,
    build_task_type=_Tasks.BuildVideoInvertedTier0Shard,
    tracker_url=VLA_TRACKER,
    namespace='/video/prod/',
)
