

class ConstObj(object):
    __done_init = False

    def on_initialize(self):
        self.__done_init = True

    def __setattr__(self, key, value):
        if self.__done_init:
            raise AttributeError('Object {} is immutable'.format(self))
        else:
            self.__dict__[key] = value

    def __eq__(self, other):
        raise NotImplementedError()

    def __hash__(self):
        raise NotImplementedError()
