import logging
import datetime


class DisjointSets(object):
    def __init__(self, id_, classes):
        self._id = id_
        self._classes = {class_: set() for class_ in classes}
        self._last_modified = datetime.datetime(1917, 11, 7)

    def ensure(self, item, target, log_level=logging.NOTSET):
        if item in self._classes[target]:
            return None
        was = 'none'
        for class_ in self._classes:
            if item in self._classes[class_]:
                self._classes[class_].discard(item)
                was = class_
        self._classes[target].add(item)
        self._last_modified = datetime.datetime.now()
        _log.log(log_level, '%s: %s -> %s on %s', self._id, was, target, item)
        return was

    def ensure_none(self, item, log_level=logging.NOTSET, set_last_modified=True):
        for class_ in self._classes:
            if item in self._classes[class_]:
                self._classes[class_].discard(item)
                _log.log(log_level, '%s: %s -> none on %s', self._id, class_, item)
                if set_last_modified:
                    self._last_modified = datetime.datetime.now()

    @property
    def all(self):
        return set.union(*(items for items in self._classes.values()))

    def get_class(self, class_):
        return self._classes[class_]

    @property
    def since_last_modified(self):
        return datetime.datetime.now() - self._last_modified


class EntityState(object):
    class Conditions(object):
        All = []

    def __init__(self):
        self._entities = {}

    def set(self, entity, condition):
        assert condition in self.Conditions.All
        self._entities[entity] = condition

    def get(self, entity):
        return self._entities.get(entity)

    def split_by_condition(self):
        conditions_entities = {condition: [] for condition in self.Conditions.All}
        for entity, condition in self._entities.items():
            conditions_entities[condition].append(entity)
        return conditions_entities

    @property
    def entities(self):
        return self._entities

    def __contains__(self, item):
        return item in self._entities


_log = logging.getLogger('disjoint_sets')
