import os


NANNY_POSSIBLE_PATH_TO_TOKEN = (
    'secrets/nanny.token',
    '~/.nanny/token',
)

SANDBOX_TOKEN_POSSIBLE_PATHS = [
    'secrets/sandbox.token',
    '~/.sandbox/token',
]


def find_nanny_token():
    if os.getenv('NANNY_TOKEN'):
        return os.getenv('NANNY_TOKEN')
    token = _find_file(NANNY_POSSIBLE_PATH_TO_TOKEN)
    if token:
        return token
    raise RuntimeError('cannot find nanny_token')


def find_sandbox_token():
    if os.getenv('SANDBOX_TOKEN'):
        return os.getenv('SANDBOX_TOKEN')
    token = _find_file(SANDBOX_TOKEN_POSSIBLE_PATHS)
    if token:
        return token
    raise RuntimeError('cannot find sandbox_token')


def _find_file(possible_paths):
    for path in possible_paths:
        absolute_path = os.path.expanduser(path)
        if os.path.exists(absolute_path):
            with open(absolute_path) as f:
                return f.read().strip()
