import logging

import infra.callisto.libraries.copier as copier
import infra.callisto.libraries.memoize as memoize


@memoize.get_cache(records_limit=10 * 1000)
def get_top_filename(rbtorrent):
    """ Return first file with no '/' in name"""
    files = copier.sky_files(rbtorrent)
    for file_descr in files:
        if '/' not in file_descr['name']:
            logging.debug('Top file: %s', file_descr['name'])
            return file_descr['name']
    raise RuntimeError('Could not find top file at %s', rbtorrent)


class ResourceNotFound(RuntimeError):
    pass


class Timeout(RuntimeError):
    pass
