# coding=utf8

import logging
import argparse

import gevent.pywsgi
import werkzeug.wsgi

import infra.callisto.controllers.viewer.lib2 as viewer

import gevent.monkey
gevent.monkey.patch_all()


def main():
    logging.basicConfig(level=logging.DEBUG)
    args = parse_args()
    states = TIERS[args.tier]()
    app = viewer.configure_app(states)
    app = werkzeug.wsgi.DispatcherMiddleware(app, {'/viewer': app})
    gevent.pywsgi.WSGIServer(('::', args.port), app).serve_forever()


TIERS = {
    'jupiter': viewer.make_jupiter,
    'callisto': viewer.make_callisto,
    'thumb': viewer.make_img_thumb,
    'video': viewer.make_video,
    'rim': viewer.make_rim,
    'img': viewer.make_images,
    'img_commercial': viewer.make_images_commercial,
}


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument('--port', help='Port to listen', type=int, required=True)
    parser.add_argument('--tier', choices=TIERS.keys(), required=True)
    return parser.parse_args()
