import re
import datetime
import collections

import retry
import requests


@retry.retry(tries=2, delay=1)
def retry_get_json_by_url(url):
    return requests.get(url, timeout=10).json()


@retry.retry(tries=2, delay=1)
def retry_get_url(url):
    return requests.get(url, timeout=10)


def get_generation_by_shard(shard):
    shard = shard.split('/')[0]
    match = _VideoImgShardTemplate.search(shard)
    if match:
        gen = shard[match.start():match.end()]
        return str(yt_state_to_timestamp(gen))
    return shard.rsplit('-', 1)[-1]


def get_generation_from_namespace(namespace):
    return namespace.strip('/').split('/')[-2]


def timestamp_to_yt_state(t):
    return datetime.datetime.fromtimestamp(int(t)).strftime('%Y%m%d-%H%M%S')


def yt_state_to_timestamp(state):
    if state == '00000000-000000':
        return 0
    state = datetime.datetime.strptime(state, '%Y%m%d-%H%M%S')
    return int(state.strftime('%s'))


def sort_dict(dct, order):
    sorted_dct = collections.OrderedDict()
    for key in order:
        if key in dct:
            sorted_dct[key] = dct[key]
    return sorted_dct


_VideoImgShardTemplate = re.compile('\\d{8}-\\d{6}$')
