#include "util.h"

#include <infra/callisto/deploy/deployer/cpp/config.pb.h>

#include <util/datetime/base.h>
#include <util/system/condvar.h>
#include <util/system/mutex.h>
#include <util/system/thread.h>


// task agnostic?
// как тогда быть со state::CHECKING?
class TTaskManager {
public:
    // пришли новые таски
    void Reset(/*tasks*/) {
        with_lock (lock_) {
        // - поставить флаг "удаляемся" тем, кого нет в списке
        // - добавить недостающие
        // - грохнуть текущий таск, если он удаляется
        // - вычистить из таблички ранее "удаленные"
            Sleep(TDuration::Seconds(1));
        }
    }

    /*TTask*/ void Next() {
        with_lock (lock_) {
        // приоритеты:
        // – сначала выдаем задание на удаление
        // – потом на обработку несделанных
        // - перепроверка где-то в другом месте?
            Sleep(TDuration::Seconds(1));
        }
    }
private:
    TMutex lock_;

private:
    /* данные:
        - spec {resource, notification}
        - last check time, check status
        - last download attempt time
        - last yt sync time
        - state: TO_REMOVE,
                 CHECKING
                 FAILED,
                 IN_PROGRESS,
                 ENQUEUED
     */
};

// 1) single consumer/single producer
// 2) wait on Pop while empty infinitely
template <typename TTask>
class TTaskQueue1 {
public:
    void Push(TTask task) {
        with_lock (tasksLock) {
            Cerr << "push " << task << Endl;
            tasks.push_back(task);
        }
        cv.Signal();
    }

    TTask Pop() {
        TGuard guard {tasksLock};
        cv.WaitI(tasksLock, [&] {return !tasks.empty();});
        TTask task = tasks.back();
        tasks.pop_back();
        Cerr << "pop " << task << Endl;
        return task;
    }

private:
    TVector<TTask> tasks;
    TMutex tasksLock;
    TCondVar cv;
};

// 2) delayed completion
template <typename TTask>
class TTaskQueue2 {
public:
    void Push(TTask task) {
        Cerr << "push " << task << Endl;
    }

    TTask Get();
    void Complete(TTask task);
};


int main(int argc, const char** argv) {
    TConfig config = ParseConfig<TConfig>(argc, argv);

    {
        TTaskQueue1<int> queue;
        TThread pushing_thread {[&queue] {
            for (int i = 0; i < 1000; ++ i) {
                queue.Push(i);
                Sleep(TDuration::Seconds(1));
            }
        }};
        pushing_thread.Start();
        for (int i = 0; i < 20; ++i) {
            queue.Pop();
        }
        pushing_thread.Join();
    }


    return 0;
}
