#pragma once

#include <library/cpp/getoptpb/getoptpb.h>

#include <util/generic/string.h>

template <typename TProtoConfig>
TProtoConfig ParseConfig(int argc, const char** argv) {
    TProtoConfig config;
    TString error;
    if (not NGetoptPb::GetoptPb(argc, argv, config, error, {.UseLetterHelpShortcut = true})) {
        ythrow yexception() << "Failed to parse config: " << error;
    }
    return config;
}

