#include <infra/callisto/deploy/deployer/config/config.pb.h>
#include <infra/callisto/protos/deploy/tables.pb.h>

#include <library/cpp/testing/common/env.h>
#include <library/cpp/testing/gtest/gtest.h>

#include <google/protobuf/text_format.h>

#include <util/folder/iterator.h>
#include <util/folder/path.h>
#include <util/stream/file.h>


namespace NPlutonium::NDeployer {

template <typename TProto>
void ValidateConfigs(const TString& relativePath, TStringBuf suffix) {
    const TFsPath configsPath = TFsPath{ArcadiaSourceRoot()} / relativePath;

    for (const FTSENT& entry : TDirIterator(configsPath, TDirIterator::TOptions(FTS_LOGICAL))) {
        const TFsPath path{entry.fts_path};
        if (path.IsFile() && path.GetName().EndsWith(suffix)) {
            SCOPED_TRACE(ToString(path));
            const TString protoText = TFileInput(path).ReadAll();
            TProto configProto;
            const bool parsed = ::google::protobuf::TextFormat::ParseFromString(protoText, &configProto);
            ASSERT_TRUE(parsed);
        }
    }
}

TEST(ValidateConfigs, Deployer) {
    ValidateConfigs<NPlutonium::NDeployer::TConfig>("infra/callisto/deploy/deployer/package/configs/deployer", ".pb.txt");
}

TEST(ValidateConfigs, Notify) {
    ValidateConfigs<NPlutonium::TStaticNotificationConfig>("infra/callisto/deploy/deployer/package/configs/notify", ".pb.txt");
}

}
