# cython: language_level=3str, language=c++

from libcpp cimport bool
from util.generic.string cimport TString


cdef extern from "search/plutonium/impl/file_system/yt_dynamic_tables/download_global.h" namespace "NPlutonium::NDynTables::NDownload":
    void ReloadGlobalConfig(
        TString configCluster,
        TString ytToken,
        TString configPathCypress
    ) nogil except +


def reload_global_config(config_cluster, yt_token, config_path_cypress):
    cdef TString c_config_cluster = config_cluster;
    cdef TString c_yt_token = yt_token;
    cdef TString c_config_path_cypress = config_path_cypress;
    with nogil:
        ReloadGlobalConfig(c_config_cluster, c_yt_token, c_config_path_cypress)


cdef extern from "search/plutonium/impl/file_system/yt_dynamic_tables/download_global.h" namespace "NPlutonium::NDynTables::NDownload":
    void Download(
        TString cluster,
        TString contentTablePath,
        TString fileId,
        TString outFileName,
        double weightFactor
    ) nogil except +


def download(cluster, content_table_path, file_id, out_file_name, weight_factor):
    cdef TString c_cluster = cluster;
    cdef TString c_content_table_path = content_table_path;
    cdef TString c_file_id = file_id;
    cdef TString c_out_file_name = out_file_name;
    cdef double c_weight_factor = weight_factor;
    # And only after coercion release GIL
    with nogil:
        Download(c_cluster, c_content_table_path, c_file_id, c_out_file_name, c_weight_factor)
