import collections


class ResolvedResource(collections.namedtuple('ResolvedResource', [
    'namespace',
    'name',
    'rbtorrent',
    'size',
])):
    def __str__(self):
        return 'ResolvedResource(namespace="{}", name="{}")'.format(self.namespace, self.name)

    def to_dict(self):
        return {
            'namespace': self.namespace,
            'name': self.name,
            'rbtorrent': self.rbtorrent,
            'size': self.size,
        }

    @classmethod
    def from_dict(cls, dict_):
        return cls(
            dict_['namespace'],
            dict_['name'],
            dict_.get('rbtorrent'),
            dict_.get('size'),
        )
