import collections
import json
import logging

import gevent.pywsgi


def serve_forever(port):
    def render_response(env, start_response):
        if env['PATH_INFO'] == '/ready':
            if __ready:
                start_response('200 OK', [('Content-type', 'text/html')])
                return 'Ready'
            else:
                start_response('503 Service Unavailable', [('Content-type', 'text/html')])
                return 'Not ready'
        elif env['PATH_INFO'] == '/unistat' or env['PATH_INFO'] == '/':
            start_response('200 OK', [('Content-type', 'application/json')])
            return json.dumps([[name, value] for name, value in __counters.iteritems()], indent=4)
        else:
            start_response('404 Not Found', [('Content-Type', 'text/html')])
            return 'Not Found'

    _log.info('Start handler on %s', port)
    gevent.pywsgi.WSGIServer(('::', int(port)), render_response).serve_forever()


def set_counter(name, value):
    __counters[name] = float(value)


def inc_counter(name, value=1):
    __counters[name] += float(value)


def push_histogram(name, value):
    signal_counter = __counters[name]
    for i in range(len(signal_counter) - 1, -1, -1):
        if signal_counter[i][0] <= value:
            signal_counter[i][1] += 1
            break


def push_time_s_histogram(name, value):
    if name not in __counters:
        # from 0s to 20m
        # intervals:
        # 1s: 0s - 10s
        # 5s: 10s - 30s
        # 30s: 30s - 5m
        # 1m: 5m - 20m
        __counters[name] = [[x, 0] for x in range(0, 10)] + \
            [[x, 0] for x in range(10, 30, 5)] + \
            [[x, 0] for x in range(30, 300, 30)] + \
            [[x, 0] for x in range(300, 1201, 60)]
    push_histogram(name, value)


def push_time_ms_histogram(name, value):
    if name not in __counters:
        # from 0ms to 1m
        # intervals:
        # 10ms: 0ms - 1s
        # 100ms: 1s - 5s
        # 1s: 5s - 1m
        __counters[name] = [[x, 0] for x in range(0, 1000, 10)] + \
            [[x, 0] for x in range(1000, 5000, 100)] + \
            [[x, 0] for x in range(5000, 60001, 1000)]
    push_histogram(name, value)


def set_ready(value):
    # one-way switch
    if value is False:
        return

    global __ready
    __ready = value


__counters = collections.defaultdict(float)
__ready = False

_log = logging.getLogger(__name__)
